/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import com.sun.net.ssl.HttpsURLConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.gcube.portlets.user.shareupdates.server.ShareUpdateServiceImpl;
import org.gcube.portlets.user.shareupdates.server.metaseeker.MetaSeeker;
import org.gcube.portlets.user.shareupdates.server.opengraph.OpenGraph;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.gcube.portlets.widgets.pickuser.shared.PickingUser;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlparser.beans.StringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextTransfromUtils {
    private static Logger _log = LoggerFactory.getLogger(ShareUpdateServiceImpl.class);

    protected static String convertFileNameAnchorHTML(String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("<span style=\"color:gray; font-size:12px;\">shared </span><a class=\"link\" href=\"").append(url).append("\" target=\"_blank\">").append("a file.").append("</a> ").toString();
        return sb.toString();
    }

    protected static String convertMentionPeopleAnchorHTML(String escapedFeedText, ArrayList<PickingUser> taggedPeople) {
        for (PickingUser tagged : taggedPeople) {
            String taggedHTML = "<a class=\"link\" style=\"font-size:14px;\" href=\"/group/data-e-infrastructure-gateway/profile?" + new String(Base64.encodeBase64((byte[])"userIdentificationParameter".getBytes())) + "=" + new String(Base64.encodeBase64((byte[])tagged.getUsername().getBytes())) + "\">" + tagged.getFullName() + "</a> ";
            escapedFeedText = escapedFeedText.replace(tagged.getFullName(), taggedHTML);
        }
        return escapedFeedText;
    }

    private static String createDescriptionFromContent(String link) {
        StringBean sb = new StringBean();
        sb.setURL(link);
        sb.setLinks(false);
        String description = sb.getStrings();
        description = description.length() > 256 ? String.valueOf(description.substring(0, 256)) + "..." : description;
        return description;
    }

    protected static String escapeHtmlAndTransformUrl(String html) {
        if (html == null) {
            return null;
        }
        String toReturn = html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        toReturn = toReturn.replaceAll("(\r\n|\n)", " <br/> ");
        toReturn = TextTransfromUtils.transformUrls((String)toReturn);
        toReturn = toReturn.replaceAll("\\s\\s", "&nbsp;&nbsp;");
        return toReturn;
    }

    protected static String extractURL(String feedText) {
        String[] parts;
        feedText = feedText.replaceAll("(\r\n|\n)", " <br/> ");
        String[] stringArray = parts = feedText.split("\\s");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String toCheck = TextTransfromUtils.getHttpToken((String)item);
            if (toCheck != null) {
                try {
                    new URL(toCheck);
                    return toCheck;
                }
                catch (MalformedURLException e) {
                    _log.error("MalformedURLException returning... ");
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    private static String getHttpToken(String item) {
        if (item.startsWith("http") || item.startsWith("www") || item.startsWith("(www") || item.startsWith("(http")) {
            if (item.startsWith("(")) {
                item = item.substring(1, item.length());
            }
            if (item.endsWith(".") || item.endsWith(")")) {
                item = item.substring(0, item.length() - 1);
            }
            item = item.startsWith("www") ? "http://" + item : item;
            System.out.println("getHttpToken returns -> " + item);
            return item;
        }
        return null;
    }

    protected static ArrayList<String> getImagesWithCleaner(URL pageURL) throws IOException {
        String inputLine;
        ArrayList<String> images = new ArrayList<String>();
        URLConnection conn = pageURL.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        Charset charset = OpenGraph.getConnectionCharset((URLConnection)conn);
        BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer headContents = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            headContents.append(String.valueOf(inputLine) + "\r\n");
        }
        HtmlCleaner cleaner = new HtmlCleaner();
        String headContentsStr = headContents.toString();
        TagNode pageData = cleaner.clean(headContentsStr);
        TagNode[] imgs = pageData.getElementsByName("img", true);
        int upTo = imgs.length > 15 ? 15 : imgs.length;
        int i = 0;
        while (i < upTo) {
            if (imgs[i].hasAttribute("src")) {
                String imageUrl = TextTransfromUtils.getImageUrlFromSrcAttribute((URL)pageURL, (String)imgs[i].getAttributeByName("src"));
                images.add(imageUrl);
                _log.trace("[FOUND image] " + imageUrl);
            }
            ++i;
        }
        return images;
    }

    protected static String getImageUrlFromSrcAttribute(URL pageURL, String srcAttr) {
        String imageUrl = srcAttr;
        _log.trace("imageUrl=" + imageUrl);
        if (imageUrl.startsWith("http") || imageUrl.startsWith("//")) {
            _log.trace("Direct link case");
            return imageUrl;
        }
        if (imageUrl.startsWith("/")) {
            _log.trace("Absolute Path case");
            imageUrl = String.valueOf(pageURL.getProtocol()) + "://" + pageURL.getHost() + imageUrl;
        } else if (imageUrl.startsWith("../")) {
            _log.trace("Relative Path case");
            String imageFolder = pageURL.toString().substring(0, pageURL.toString().lastIndexOf("/"));
            imageUrl = String.valueOf(imageFolder) + "/" + imageUrl;
        } else if (!imageUrl.contains("/") || !imageUrl.startsWith("/")) {
            String imageFolder;
            _log.trace("probably in the same folder");
            String checkedURL = pageURL.toString();
            if (!checkedURL.endsWith("/")) {
                checkedURL = String.valueOf(checkedURL) + "/";
            }
            if ((imageFolder = pageURL.toString().substring(0, pageURL.toString().lastIndexOf("/"))).compareToIgnoreCase("http:/") == 0 || imageFolder.compareToIgnoreCase("https:/") == 0) {
                imageFolder = pageURL.toString();
            }
            imageUrl = String.valueOf(imageFolder) + "/" + imageUrl;
        } else if (!imageUrl.startsWith("http")) {
            _log.trace("In the root");
            imageUrl = pageURL.toExternalForm().endsWith("/") ? String.valueOf(pageURL.toExternalForm()) + imageUrl : String.valueOf(pageURL.toExternalForm()) + "/" + imageUrl;
        }
        return imageUrl;
    }

    protected static LinkPreview getInfoFromHTML(URLConnection connection, URL pageUrl, String link, String host) throws Exception {
        LinkPreview toReturn = null;
        String title = "";
        String description = "";
        URLConnection conn = pageUrl.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        MetaSeeker ms = null;
        try {
            title = TextTransfromUtils.getTitleFromHeader((URL)pageUrl);
            _log.trace("Found Title=" + title);
            ms = new MetaSeeker(connection, pageUrl);
            description = ms.getContent("description") != null && !ms.getContent("description").isEmpty() ? ms.getContent("description") : TextTransfromUtils.createDescriptionFromContent((String)link);
            ArrayList images = new ArrayList();
            images = TextTransfromUtils.getImagesWithCleaner((URL)pageUrl);
            toReturn = new LinkPreview(title, description, link, host, images);
        }
        catch (Exception e) {
            _log.error("[MANUAL-PARSE] Something wrong with the meta seeker returning ... ");
            e.printStackTrace();
            return toReturn;
        }
        return toReturn;
    }

    private static String getTitleFromHeader(URL pageURL) throws IOException {
        String inputLine;
        URLConnection conn = pageURL.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        Charset charset = OpenGraph.getConnectionCharset((URLConnection)conn);
        BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer headContents = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            if (inputLine.contains("</head>")) {
                inputLine = inputLine.substring(0, inputLine.indexOf("</head>") + 7);
                inputLine = inputLine.concat("<body></body></html>");
                headContents.append(String.valueOf(inputLine) + "\r\n");
                break;
            }
            headContents.append(String.valueOf(inputLine) + "\r\n");
        }
        String headContentsStr = headContents.toString();
        HtmlCleaner cleaner = new HtmlCleaner();
        TagNode pageData = cleaner.clean(headContentsStr);
        TagNode[] title = pageData.getElementsByName("title", true);
        if (title != null && title.length > 0 && title[0].getChildren().size() > 0) {
            String theTitle = title[0].getChildren().get(0).toString();
            _log.trace("theTitle: " + theTitle);
            return theTitle;
        }
        return "No-title";
    }

    protected static String replaceAmpersand(String toReplace) {
        String toReturn = toReplace.replaceAll("&amp;", "&");
        return toReturn;
    }

    protected static String transformUrls(String feedText) {
        StringBuilder sb = new StringBuilder();
        String[] parts = feedText.split("\\s");
        int i = 0;
        while (i < parts.length) {
            String toCheck = TextTransfromUtils.getHttpToken((String)parts[i]);
            if (toCheck != null) {
                try {
                    URL url = new URL(toCheck);
                    if (i == 0 && parts.length == 1) {
                        return sb.append("<span style=\"color:gray; font-size:12px;\">shared </span><a class=\"link\" href=\"").append(url).append("\" target=\"_blank\">").append("a link.").append("</a> ").toString();
                    }
                    sb.append("<a class=\"link\" style=\"font-size:14px;\" href=\"").append(url).append("\" target=\"_blank\">").append(url).append("</a> ");
                }
                catch (MalformedURLException e) {
                    _log.error("MalformedURLException returning... ");
                    return feedText;
                }
            } else {
                sb.append(parts[i]);
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected static void trustAllHTTPSConnections() {
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)sc.getSocketFactory());
        }
        catch (Exception e) {
            System.out.println("Error" + e);
        }
    }
}

