/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadToWorkspaceThread
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(UploadToWorkspaceThread.class);
    public static final String ATTACHMENT_FOLDER = "Shared attachments";
    private String username;
    private String fileName;
    private String fileabsolutePathOnServer;

    public UploadToWorkspaceThread(String username, String fileName, String fileabsolutePathOnServer) {
        this.username = username;
        this.fileName = fileName;
        this.fileabsolutePathOnServer = fileabsolutePathOnServer;
    }

    @Override
    public void run() {
        try {
            String currScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set("/" + PortalContext.getConfiguration().getInfrastructureName());
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(this.username).getWorkspace();
            _log.info("File to upload=" + this.fileabsolutePathOnServer);
            File file = new File(this.fileabsolutePathOnServer);
            FileInputStream fileData = new FileInputStream(file);
            _log.info("Trying to get Group folder for scope=" + currScope);
            WorkspaceFolder folder = ws.getVREFolderByScope(currScope);
            WorkspaceFolder attachment = null;
            try {
                attachment = (WorkspaceFolder)ws.getItemByPath(String.valueOf(folder.getPath()) + "/" + ATTACHMENT_FOLDER);
            }
            catch (ItemNotFoundException e) {
                _log.info("Shared attachments Workspace Folder does not exists, creating it for " + currScope);
                attachment = ws.createFolder(ATTACHMENT_FOLDER, "Folder created automatically by the System", folder.getId());
            }
            String itemName = WorkspaceUtil.getUniqueName((String)this.fileName, (WorkspaceFolder)attachment);
            FolderItem item = WorkspaceUtil.createExternalFile((WorkspaceFolder)attachment, (String)itemName, (String)"File added automatically by Share Updates", null, (InputStream)fileData);
            _log.debug("Uploaded " + item.getName() + " - Returned Workspace id=" + item.getId());
            ScopeProvider.instance.set(currScope);
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.error("Something wrong while uploading " + this.fileName + " in Workspace " + e.getMessage());
        }
    }
}

