/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.questions.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.questions.client.QuestionsService;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.RoleModel;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionsServiceImpl
extends RemoteServiceServlet
implements QuestionsService {
    private static final Logger _log = LoggerFactory.getLogger(QuestionsServiceImpl.class);
    private static final String TEST_USER = "test.user";

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = TEST_USER;
        user = "massimiliano.assante";
        return user;
    }

    public ArrayList<UserInfo> getManagers() {
        ArrayList<UserInfo> toReturn = new ArrayList<UserInfo>();
        ASLSession session = this.getASLSession();
        if (session.getUsername().compareTo(TEST_USER) == 0) {
            _log.error("User is NULL, session expired?");
            return new ArrayList<UserInfo>();
        }
        if (this.isWithinPortal()) {
            _log.trace("Asking user and roles ...");
            LiferayUserManager userM = new LiferayUserManager();
            HashMap usersAndRoles = null;
            try {
                usersAndRoles = userM.listUsersAndRolesByGroup(this.getCurrentGroupID());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Set users = usersAndRoles.keySet();
            for (UserModel usr : users) {
                List roles = (List)usersAndRoles.get(usr);
                for (int i = 0; i < roles.size(); ++i) {
                    if (!((RoleModel)roles.get(i)).getRoleName().equals("VRE-Manager")) continue;
                    String username = usr.getScreenName();
                    _log.trace("Found Manager ... " + username);
                    String fullName = usr.getFullname();
                    String thumbnailURL = "images/Avatar_default.png";
                    try {
                        User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
                        thumbnailURL = user.isMale() ? "/image/user_male_portrait?img_id=" + user.getPortraitId() : "/image/user_female_portrait?img_id=" + user.getPortraitId();
                        HashMap vreNames = new HashMap();
                        String headline = user.getJobTitle();
                        UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, headline, this.getUserProfileLink(username), user.isMale(), false, vreNames);
                        toReturn.add(userInfo);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            toReturn.add(new UserInfo("pino.pino", "With Photo Third User", null, "email@email.it", "", true, false, null));
            toReturn.add(new UserInfo("giorgi.giorgi", "Test Fourth User", null, "email@email.it", "", true, false, null));
            toReturn.add(new UserInfo("pinetti.giorgi", "Test Fifth User", null, "email@email.it", "", true, false, null));
            toReturn.add(new UserInfo("massimiliano.pinetti", "Test Sixth User", null, "email@email.it", "", true, false, null));
            toReturn.add(new UserInfo("massimiliano.giorgi", "Eighth Testing User", null, "email@email.it", "", true, false, null));
        }
        return toReturn;
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    private String getCurrentGroupID() throws Exception {
        LiferayGroupManager groupM = new LiferayGroupManager();
        ASLSession session = this.getASLSession();
        _log.debug("The current group NAME is --> " + session.getGroupName());
        try {
            return groupM.getGroupId(session.getGroupName());
        }
        catch (GroupRetrievalFault e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getUserProfileLink(String username) {
        return "profile?" + new String(Base64.encodeBase64((byte[])"userIdentificationParameter".getBytes())) + "=" + new String(Base64.encodeBase64((byte[])username.getBytes()));
    }
}

