/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator;

public class OperatorCategory
implements IsSerializable {
    private String id;
    private String name;
    private String briefDescription;
    private String description;
    private List<Operator> operators = new ArrayList();
    private boolean hasImage = false;

    public OperatorCategory() {
    }

    public OperatorCategory(String id, String briefDescription, String description) {
        this.id = id;
        this.setNameFromId();
        this.briefDescription = briefDescription;
        this.description = description;
    }

    public OperatorCategory(String id, String briefDescription, String description, boolean hasImage) {
        this.id = id;
        this.setNameFromId();
        this.briefDescription = briefDescription;
        this.description = description;
        this.hasImage = hasImage;
    }

    public OperatorCategory(String id, String briefDescription, String description, List<Operator> operators) {
        this.id = id;
        this.setNameFromId();
        this.briefDescription = briefDescription;
        this.description = description;
        this.operators = operators;
    }

    public OperatorCategory(String id, String name, String briefDescription, String description, List<Operator> operators) {
        this.id = id;
        this.name = name;
        this.briefDescription = briefDescription;
        this.description = description;
        this.operators = operators;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Operator> getOperators() {
        return this.operators;
    }

    public void setOperators(List<Operator> operators) {
        this.operators = operators;
    }

    public void addOperator(Operator operator) {
        this.operators.add(operator);
    }

    private void setNameFromId() {
        if (this.id != null) {
            String name = "";
            boolean precUnderscore = true;
            for (int i = 0; i < this.id.length(); ++i) {
                char c = this.id.charAt(i);
                if (c == '_') {
                    precUnderscore = true;
                    name = name + " ";
                    continue;
                }
                name = name + (precUnderscore ? Character.toUpperCase(c) : Character.toLowerCase(c));
                if (!precUnderscore) continue;
                precUnderscore = false;
            }
            this.name = name;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasImage() {
        return this.hasImage;
    }

    public void setHasImage(boolean hasImage) {
        this.hasImage = hasImage;
    }

    public OperatorCategory clone() {
        OperatorCategory op = new OperatorCategory(this.id, this.name, this.briefDescription, this.description, new ArrayList(this.operators));
        op.setHasImage(this.hasImage);
        return op;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OperatorCategory [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", briefDescription=");
        builder.append(this.briefDescription);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", operators=");
        builder.append(this.operators);
        builder.append(", hasImage=");
        builder.append(this.hasImage);
        builder.append("]");
        return builder.toString();
    }
}

