package org.gcube.portlets.user.occurrencemanagement.server.service;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.harmonization.occurrence.OccurrenceStreamer;
import org.gcube.data.harmonization.occurrence.Reconciliation;
import org.gcube.data.harmonization.occurrence.impl.ReconciliationImpl;
import org.gcube.data.harmonization.occurrence.impl.model.Computation;
import org.gcube.data.harmonization.occurrence.impl.model.PagedRequestSettings;
import org.gcube.data.harmonization.occurrence.impl.model.Resource;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalComputation;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalFeature;
import org.gcube.data.harmonization.occurrence.impl.model.types.OperationType;
import org.gcube.data.harmonization.occurrence.impl.readers.ParserConfiguration;

public class ReconciliationService {
	
	private Reconciliation reconciliation;
	private String scope;
	private String username;
	private URI host = URI.create("http://dbtest.next.research-infrastructures.eu:8888");
	
	public static Logger logger = Logger.getLogger(ReconciliationService.class);
	
	public ReconciliationService(String scope, ASLSession session) throws Exception {
		
		try{
		this.scope = scope;
		this.username =  session.getUsername();
		ScopeProvider.instance.set(scope.toString());
		logger.trace("Create ReconciliationService");
//		System.out.println("Create ReconciliationService");
		reconciliation=new ReconciliationImpl(username);
//		reconciliation=new ReconciliationImpl(scope, username, host);
		}catch (Exception e) {
			e.printStackTrace();
			logger.error("Error on create ReconciliationService " +e.getMessage());
			throw new Exception("Error on on create ReconciliationService");
		}
	}

	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public List<Resource> getDataList() throws Exception{
		return reconciliation.getDataSets();
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public List<StatisticalFeature> getCapabilities() throws Exception{
		return reconciliation.getCapabilities();
	}
	
	/**
	 * 
	 * @throws Exception
	 */
	public void closeConnection() throws Exception{
		reconciliation.closeTableConnection();
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public  List<Computation> getSubmittedOperationList() throws Exception{
		return reconciliation.getSubmittedOperationList();
	}
	
	/**
	 * 
	 * @param stat
	 * @param map
	 * @param name
	 * @param description
	 * @throws Exception
	 */
	public void submitOperation(StatisticalComputation stat, Map<String, String> map, String name, String description) throws Exception{
		reconciliation.submitOperation(stat, map,name,description);
	}
	/**
	 * 
	 * @param id
	 * @return list Field
	 * @throws Exception
	 */
	public List<String> openTableInspectionById(String id) throws Exception{
		return reconciliation.openTableInspection(id);
	}
	
	/**
	 * 
	 * @param pagedRequestSettings
	 * @return
	 * @throws Exception
	 */
	public String getJSONImported(PagedRequestSettings pagedRequestSettings) throws Exception{
		return reconciliation.getJSONImported(pagedRequestSettings);
	}
	
	public String getUrlFromTableId(String tableId) throws Exception{
		return reconciliation.getTableUrl(tableId);
	}
	
	/**
	 * 
	 * @param csvFile
	 * @param parserConfiguration
	 * @param fileName
	 * @param fileDescription
	 * @return
	 * @throws Exception
	 */
	public  OccurrenceStreamer importOccurrences(File csvFile, ParserConfiguration parserConfiguration, String fileName, String fileDescription) throws Exception{
		return reconciliation.getStreamer(csvFile, parserConfiguration,fileName, fileDescription);
	}
	
	/**
	 * 
	 * @param resourceId
	 * @param operationType
	 * @return
	 * @throws Exception
	 */
	public File getResourceAsFile(String resourceId, OperationType operationType) throws Exception{
		return reconciliation.getResourceAsFile(resourceId, operationType);

	}
	
	/**
	 * 
	 * @param resourceId
	 * @throws Exception
	 */
	public void deleteResourceById(String resourceId) throws Exception{
		 reconciliation.removeComputationById(resourceId);
	}

}
