/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.event;

import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;

import com.google.gwt.event.shared.GwtEvent;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class DeleteResourceEvent extends GwtEvent<DeleteResourceEventHandler> {
	
	public static final GwtEvent.Type<DeleteResourceEventHandler> TYPE = new Type<DeleteResourceEventHandler>();
	private String operationId;
	private ElaborationType elaborationType;
	private String occcurrenceId;

	@Override
	public Type<DeleteResourceEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(DeleteResourceEventHandler handler) {
		handler.onDeleteResource(this);	
	}
	
	public DeleteResourceEvent(String operationId, String occurrenceId, ElaborationType type) {
		this.operationId = operationId;
		this.elaborationType = type;
		this.occcurrenceId = occurrenceId;
	}
	public String getResourceId() {
		return operationId;
	}

	public ElaborationType getElaborationType() {
		return elaborationType;
	}

	public String getOcccurrenceId() {
		return occcurrenceId;
	}
}
