/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.server.util;

import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.user.csvimportwizard.server.csv.CSVTarget;
import org.gcube.portlets.user.csvimportwizard.server.csv.CSVTargetRegistry;
import org.gcube.portlets.user.occurrencemanagement.server.csv.CsvImportServer;
import org.gcube.portlets.user.occurrencemanagement.server.service.ReconciliationService;

public class SessionUtil {
    public static final String USERNAME_ATTRIBUTE = "username";
    public static final String RECONCILIATION_SERVICE = "occurrences_reconciliation_service";
    private static final String CSV_SERVICE = "csv_service";
    public static final String TEST_SCOPE = "/gcube/devsec/devVRE";
    public static final String TEST_USER = "francesco.mangiacrapa";
    public static Logger logger = Logger.getLogger(SessionUtil.class);
    public static HashMap<String, ReconciliationService> mapReconcilationService = new HashMap();

    public static ASLSession getAslSession(HttpSession httpSession) {
        String sessionID = httpSession.getId();
        String user = (String)httpSession.getAttribute(USERNAME_ATTRIBUTE);
        if (user == null) {
            logger.error((Object)"WORKSPACE PORTLET STARTING IN TEST MODE - NO USER FOUND");
            httpSession.setAttribute(USERNAME_ATTRIBUTE, (Object)TEST_USER);
            ASLSession session = SessionManager.getInstance().getASLSession(sessionID, TEST_USER);
            session.setScope(TEST_SCOPE);
            return session;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public static ReconciliationService getService(ASLSession session) throws Exception {
        ReconciliationService service = (ReconciliationService)session.getAttribute(RECONCILIATION_SERVICE);
        if (service == null) {
            logger.trace((Object)"Service not found, creating it");
            service = new ReconciliationService(session.getScope(), session);
            session.setAttribute(RECONCILIATION_SERVICE, (Object)service);
        }
        return service;
    }

    public static CsvImportServer getCsvImportServer(ASLSession session) throws Exception {
        CsvImportServer csvImportService = (CsvImportServer)session.getAttribute(CSV_SERVICE);
        if (csvImportService == null) {
            logger.trace((Object)"CsvImportServer not found, creating it");
            csvImportService = new CsvImportServer();
            CSVTargetRegistry.getInstance().add((CSVTarget)csvImportService);
            session.setAttribute(CSV_SERVICE, (Object)csvImportService);
        }
        return csvImportService;
    }

    public static Logger getLogger() {
        return logger;
    }
}

