/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.client.statistical.form;

import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.AbstractField;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.TableItem;

public class ColumnField
extends AbstractField {
    private VerticalPanel vp = new VerticalPanel();
    String value = null;
    private String defaultColumn;
    SimpleComboBox<String> listBox;
    private String referredTabularParameterName;

    public ColumnField(Parameter parameter) {
        super(parameter);
        ColumnParameter p = (ColumnParameter)parameter;
        this.referredTabularParameterName = p.getReferredTabularParameterName();
        this.defaultColumn = p.getDefaultColumn();
        this.listBox = new SimpleComboBox();
        this.listBox.setAllowBlank(false);
        this.listBox.setForceSelection(true);
        this.listBox.setEditable(false);
        this.listBox.setTriggerAction(ComboBox.TriggerAction.ALL);
        if (p.getDescription() != null) {
            this.listBox.setTitle(p.getDescription());
        }
        this.listBox.setFieldLabel(p.getName());
        this.listBox.setEnabled(false);
        this.listBox.mask();
        this.showNoSelectionField();
    }

    private void showNoSelectionField() {
        this.vp.removeAll();
        this.vp.add((Widget)this.listBox);
        this.vp.add((Widget)new Html("<div class='workflow-parameters-description'>Select table from parameter " + this.referredTabularParameterName + "</div>"));
        this.vp.layout();
    }

    private void showFieldWithSelection(TableItem tableItem) {
        this.vp.removeAll();
        this.vp.add((Widget)this.listBox);
        this.vp.add((Widget)new Html("<div class='workflow-parameters-description'>Columns of Table " + tableItem.getName() + "</div>"));
        this.vp.layout();
    }

    public String getValue() {
        return (String)((SimpleComboValue)this.listBox.getValue()).getValue();
    }

    public Widget getWidget() {
        return this.vp;
    }

    public void fireEvent(Object message) {
        if (message == null) {
            this.listBox.removeAll();
            this.listBox.clear();
            this.listBox.setEnabled(false);
            this.listBox.mask();
            this.showNoSelectionField();
        } else {
            TableItem tableItem = (TableItem)message;
            this.listBox.removeAll();
            this.listBox.add(tableItem.getColumnNames());
            if (tableItem.getColumnNames().contains(this.defaultColumn)) {
                this.listBox.setSimpleValue((Object)this.defaultColumn);
            }
            this.listBox.setEnabled(true);
            this.listBox.unmask();
            this.showFieldWithSelection(tableItem);
        }
    }
}

