/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.client.job;

import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.user.occurrencemanagement.client.job.GridJob;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobColumnConfig;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobManager;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobOccurrenceProgressBar;
import org.gcube.portlets.user.occurrencemanagement.client.job.WindowInfoJobsSpecies;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationStatus;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

public class JobManager {
    private GridJob gridJob;
    private HashMap<String, JobOccurrenceProgressBar> hashProgressBars = new HashMap();

    public JobManager(JobColumnConfig colConfig) {
        this.gridJob = new GridJob(colConfig);
    }

    public boolean addListJob(List<JobOccurrencesModel> jobsModel) {
        boolean isLoading = false;
        for (JobOccurrencesModel jobModel : jobsModel) {
            isLoading = this.addJob(jobModel);
        }
        return isLoading;
    }

    public boolean addJob(JobOccurrencesModel jobModel) {
        boolean isLoading = false;
        JobOccurrenceProgressBar jobsBar = (JobOccurrenceProgressBar)this.hashProgressBars.get(jobModel.getIdentifier());
        if (jobsBar != null) {
            WindowInfoJobsSpecies win = (WindowInfoJobsSpecies)jobsBar.getData("win");
            if (win != null) {
                win.setDescriptionByModel(jobModel);
                win.layout();
                jobsBar.setData("win", (Object)win);
            }
            if (jobsBar.isCompleted()) {
                System.out.println("jobsBar " + jobModel.getName() + " is completed, status " + jobModel.getDownloadState().toString() + " return");
                return true;
            }
            this.updateProgressBarView(jobsBar, jobModel);
            this.gridJob.updateStatus(jobModel, jobsBar);
        } else if (jobModel.getIdentifier() != null && !jobModel.getIdentifier().isEmpty()) {
            JobOccurrenceProgressBar jobProgressBar = new JobOccurrenceProgressBar(jobModel.getIdentifier(), jobModel.getDownloadState().toString());
            this.gridJob.addJobIntoGrid(jobModel, jobProgressBar);
            this.updateProgressBarView(jobProgressBar, jobModel);
            this.hashProgressBars.put(jobModel.getIdentifier(), jobProgressBar);
        }
        this.gridJob.layout();
        return isLoading;
    }

    private boolean updateProgressBarView(JobOccurrenceProgressBar jobsBar, JobOccurrencesModel jobModel) {
        switch (1.$SwitchMap$org$gcube$portlets$user$occurrencemanagement$shared$ElaborationStatus[jobModel.getDownloadState().ordinal()]) {
            case 1: {
                jobsBar.progressStop();
                jobsBar.updateProgress(0.0f);
                jobsBar.setCompleted(false);
                jobsBar.setProgressText(ElaborationStatus.PENDING.getLabel());
                break;
            }
            case 2: {
                jobsBar.getElement().getStyle().setBorderColor("#000000");
                jobsBar.progressStop();
                jobsBar.updateProgress(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(ElaborationStatus.COMPLETED.getLabel());
                break;
            }
            case 3: {
                jobsBar.setProgressText(ElaborationStatus.RUNNING.getLabel());
                jobsBar.progressStart();
                return true;
            }
            case 4: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                jobsBar.progressStop();
                jobsBar.updateProgress(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(ElaborationStatus.FAILED.getLabel());
                break;
            }
            case 5: {
                jobsBar.progressStop();
                jobsBar.updateProgress(0.0f);
                jobsBar.setCompleted(false);
                jobsBar.updateText(ElaborationStatus.DEQUEUE.getLabel());
            }
            case 6: {
                jobsBar.progressStop();
                jobsBar.updateProgress(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(ElaborationStatus.STOPPED.getLabel());
            }
        }
        return false;
    }

    public void removeSpeciesJob(String hashHPKey) {
        this.hashProgressBars.remove(hashHPKey);
    }

    public void reset() {
        this.hashProgressBars.clear();
        this.gridJob.resetStore();
    }

    public GridJob getGridJob() {
        return this.gridJob;
    }
}

