/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.client.job;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.filters.DateFilter;
import com.extjs.gxt.ui.client.widget.grid.filters.Filter;
import com.extjs.gxt.ui.client.widget.grid.filters.GridFilters;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import java.util.HashMap;
import org.gcube.portlets.user.occurrencemanagement.client.job.GridJob;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobColumnConfig;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobOccurrenceProgressBar;
import org.gcube.portlets.user.occurrencemanagement.client.job.WindowInfoJobsSpecies;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

public class GridJob
extends ContentPanel {
    private GroupingStore<BaseModelData> store;
    protected Grid<BaseModelData> grid;
    private HashMap<String, WindowInfoJobsSpecies> listWindowInfo = new HashMap();
    private JobColumnConfig jobColumnConfig;
    protected ColumnModel cm;

    public GridJob(JobColumnConfig colConfig) {
        this.setLayout((Layout)new FitLayout());
        this.jobColumnConfig = colConfig;
        this.cm = new ColumnModel(this.jobColumnConfig.getListColumnConfig());
        this.setBodyBorder(false);
        this.setHeaderVisible(false);
        this.initGrid();
    }

    public void initGrid() {
        GridFilters filters = new GridFilters();
        filters.setLocal(true);
        DateFilter dateFilterStart = new DateFilter("Start Time");
        DateFilter dateFilterEnd = new DateFilter("End Time");
        filters.addFilter((Filter)dateFilterStart);
        filters.addFilter((Filter)dateFilterEnd);
        this.store = new GroupingStore();
        this.grid = new Grid((ListStore)this.store, this.cm);
        this.grid.setLoadMask(true);
        1 downloadStateRenderer = new /* Unavailable Anonymous Inner Class!! */;
        if (this.jobColumnConfig.isStatusAsString()) {
            this.jobColumnConfig.getStatusColumnConfig().setRenderer((GridCellRenderer)downloadStateRenderer);
        }
        2 jobSpeciesRenderer = new /* Unavailable Anonymous Inner Class!! */;
        if (this.jobColumnConfig.isStatusAsProgress()) {
            this.jobColumnConfig.getProgressStatusColumnConfig().setRenderer((GridCellRenderer)jobSpeciesRenderer);
            this.jobColumnConfig.getProgressStatusColumnConfig().setFixed(true);
        }
        this.grid.getView().setEmptyText("Empty");
        this.grid.getView().setShowDirtyCells(false);
        this.grid.getView().setShowInvalidCells(false);
        this.grid.setBorders(false);
        this.grid.setColumnLines(true);
        this.grid.addPlugin((ComponentPlugin)filters);
        this.grid.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        this.add((Component)this.grid);
    }

    public void addJobIntoGrid(JobOccurrencesModel jobModel, JobOccurrenceProgressBar jobProgressBar) {
        BaseModelData baseModel = this.convertOccurrenceModel(jobModel, jobProgressBar);
        this.grid.getStore().add((ModelData)baseModel);
        this.updateJobInfo(jobModel);
    }

    public void updateProgressSize(int indexRow, int columnWidth, int colIndex) {
        if (this.jobColumnConfig.isStatusAsProgress() && this.grid.getView().getWidget(indexRow, colIndex) != null && this.grid.getView().getWidget(indexRow, colIndex) instanceof JobOccurrenceProgressBar) {
            ((JobOccurrenceProgressBar)this.grid.getView().getWidget(indexRow, colIndex)).setWidth(columnWidth - 13);
        }
    }

    public void updateProgressSize() {
        if (this.jobColumnConfig.isStatusAsProgress()) {
            int columnIndex = this.grid.getColumnModel().indexOf(this.jobColumnConfig.getProgressStatusColumnConfig());
            int columnWidth = this.grid.getColumnModel().getColumn(columnIndex).getWidth();
            this.updateProgressSizeByResize(columnWidth, columnIndex);
        }
    }

    public void updateProgressSizeByResize(int columnWidth, int colIndex) {
        if (this.jobColumnConfig.isStatusAsProgress()) {
            for (int i = 0; i < this.grid.getStore().getCount(); ++i) {
                if (this.grid.getView().getWidget(i, colIndex) == null || !(this.grid.getView().getWidget(i, colIndex) instanceof JobOccurrenceProgressBar)) continue;
                ((JobOccurrenceProgressBar)this.grid.getView().getWidget(i, colIndex)).setWidth(columnWidth - 13);
            }
        }
    }

    private void updateJobInfo(JobOccurrencesModel jobModel) {
        WindowInfoJobsSpecies win = (WindowInfoJobsSpecies)this.listWindowInfo.get(jobModel.getIdentifier());
        if (win == null) {
            win = new WindowInfoJobsSpecies();
        }
        win.setWindowTitle(jobModel.getName());
        win.setDescriptionByModel(jobModel);
        this.listWindowInfo.put(jobModel.getIdentifier(), win);
    }

    public void updateStatus(JobOccurrencesModel jobModel, JobOccurrenceProgressBar jobProgressBar) {
        BaseModelData job = (BaseModelData)this.grid.getStore().findModel("jobIdentifier", (Object)jobModel.getIdentifier());
        if (job != null) {
            job.set("Name", (Object)jobModel.getName());
            job.set("Status", (Object)jobModel.getDownloadState());
            job.set("End Time", (Object)jobModel.getEndTime());
            job.set("Status Progress", (Object)jobProgressBar);
            this.updateJobInfo(jobModel);
            this.grid.getStore().update((ModelData)job);
        }
    }

    public void removeSpeciesJobByIdentifier(String jobIdentifier) {
        BaseModelData job = (BaseModelData)this.grid.getStore().findModel("jobIdentifier", (Object)jobIdentifier);
        if (job != null) {
            this.grid.getStore().remove((ModelData)job);
        }
    }

    public Grid<BaseModelData> getGrid() {
        return this.grid;
    }

    public GroupingStore<BaseModelData> getStore() {
        return this.store;
    }

    public HashMap<String, WindowInfoJobsSpecies> getListWindowInfo() {
        return this.listWindowInfo;
    }

    public void resetStore() {
        this.grid.getStore().removeAll();
    }

    public BaseModelData convertOccurrenceModel(JobOccurrencesModel jobModel, JobOccurrenceProgressBar jobProgressBar) {
        BaseModelData baseModelData = new BaseModelData();
        if (jobModel != null) {
            baseModelData.set("jobIdentifier", (Object)jobModel.getIdentifier());
            baseModelData.set("Name", (Object)jobModel.getName());
            baseModelData.set("Status Progress", (Object)jobProgressBar);
            baseModelData.set("Type", (Object)jobModel.getType());
            baseModelData.set("Status", (Object)jobModel.getDownloadState());
            baseModelData.set("Start Time", (Object)jobModel.getStartTime());
            baseModelData.set("End Time", (Object)jobModel.getEndTime());
            baseModelData.set("OccurrenceModel", (Object)jobModel);
            baseModelData.set("Description", (Object)jobModel.getDescription());
            baseModelData.set("Resource type", (Object)jobModel.getResourceType());
            if (jobModel.getComputation() != null) {
                baseModelData.set("Computation id", (Object)jobModel.getComputation().getId());
            }
        }
        return baseModelData;
    }
}

