package org.gcube.portlets.user.occurrencemanagement.client.view.panel.operation;

import java.util.Arrays;
import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.event.AddComputationPanelEvent;
import org.gcube.portlets.user.occurrencemanagement.client.job.WindowInfoJobsSpecies;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.Style.SelectionMode;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GroupColumnData;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.AbstractImagePrototype;

public class GridAlgorithmAvailablePanel extends ContentPanel{

	private static final String DESCRIPTION = "description";
	private static final String ID = "id";
	private static final String NAME = "name";
	
	private static final String INFO = "Info";
	private static final String COMPUTATION = "Computation";
	private static final String CATEGORY = "Category";
	
	private GroupingStore<BaseModelData> store;
	private Grid<BaseModelData> grid;
	private ToolBar toolbar;
	
	private Button buttonInfo;
	private Button buttonComputation;
		
	public GridAlgorithmAvailablePanel() {
		setLayout(new FitLayout());
		setBodyBorder(false);

		ColumnConfig name = new ColumnConfig(NAME, NAME, 200);
		ColumnConfig category = new ColumnConfig(CATEGORY, CATEGORY, 200);

		final ColumnModel cm = new ColumnModel(Arrays.asList(name,category));
		
		store = new GroupingStore<BaseModelData>();
		
		grid = new Grid<BaseModelData>(store, cm);
		grid.setLoadMask(true); 
		
		grid.getSelectionModel().addSelectionChangedListener(new SelectionChangedListener<BaseModelData>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<BaseModelData> se) {
				System.out.println("selection grid change");
				
				BaseModelData target = se.getSelectedItem();
				
				if(target!=null)
					enableButtonOnClick(true);
				else
					enableButtonOnClick(false);
				
			}
		});
		
		
		store.groupBy(CATEGORY); 
	    GroupingView view = new GroupingView();  
	    view.setShowGroupedColumn(false);  
	    view.setForceFit(true); 
	 	grid.setView(view);
	    
	    view.setGroupRenderer(new GridGroupRenderer() {  
	      public String render(GroupColumnData data) {  
	        String f = cm.getColumnById(data.field).getHeader();  
	        String l = data.models.size() == 1 ? "Item" : "Items";  
	        return f + ": " + data.group + " (" + data.models.size() + " " + l + ")";  
	      }  
	    });  
	      
		grid.getView().setAutoFill(true);
		grid.getView().setEmptyText("Empty");
		grid.getView().setShowDirtyCells(false);
		grid.getView().setShowInvalidCells(false);
	
//		setAlphanumericStoreSorter(grid);
		
		grid.setAutoExpandColumn(NAME);
		grid.setBorders(false);
		grid.setStripeRows(true);
		grid.setColumnLines(true);
		
		grid.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
		
		createGridToolBar();
		createMenuItemsOnGrid();
		
		enableButtonOnClick(false);
		
		add(grid);
		
	}

	public void loadListOperator(List<Operator> result) {

		for (Operator operator : result) {
			
			BaseModelData baseModel = new BaseModelData();
			
			baseModel.set(ID, operator.getId());
			baseModel.set(DESCRIPTION, operator.getDescription());
			baseModel.set(NAME, operator.getName());
			baseModel.set(CATEGORY, operator.getCategory().getName());
			baseModel.set(operator.getId(), operator);
			
			grid.getStore().add(baseModel);
		}
		
	}
	
	
	private void createGridToolBar(){
		
		this.toolbar = new ToolBar();
		
		buttonInfo = new Button(INFO);
		buttonInfo.setScale(ButtonScale.MEDIUM);
		buttonInfo.setIcon(AbstractImagePrototype.create(Resources.getImageInfo()));
		buttonInfo.setStyleAttribute("margin-left", "5px");
		buttonInfo.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {
				
				BaseModelData baseModel = grid.getSelectionModel().getSelectedItem();
				
				if(baseModel!=null){
					
					WindowInfoJobsSpecies win = new WindowInfoJobsSpecies();
					win.setWindowTitle((String) baseModel.get(NAME));
					win.setDescription((String) baseModel.get(DESCRIPTION));

					win.show();
				}
			}
		});
		
		buttonComputation =  new Button(COMPUTATION);
		buttonComputation.setIcon(Resources.addOperator());
		buttonComputation.setScale(ButtonScale.MEDIUM);

		buttonComputation.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				BaseModelData baseModel = grid.getSelectionModel().getSelectedItem();
				
				if(baseModel!=null){
					
					String id = baseModel.get(ID);
					
					System.out.println("id " + id);
					Operator operator = (Operator) baseModel.get(id);
					
					System.out.println("operator" + operator);
					OccurrenceApplicationController.getEventBus().fireEvent(new AddComputationPanelEvent(operator));
				
				}
				
			}
		});
		
		toolbar.add(buttonInfo);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonComputation);
		toolbar.add(new SeparatorToolItem());
		
		setTopComponent(toolbar);
	}


	public void createMenuItemsOnGrid(){
	
		
		Menu menu = new Menu();
		
		MenuItem menuInfo = new MenuItem(); 
		menuInfo.setId(INFO);
		menuInfo.setText(INFO);  
		menuInfo.setIcon(AbstractImagePrototype.create(Resources.getImageInfo()));
		
		menuInfo.addSelectionListener(new SelectionListener<MenuEvent>() {

			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData baseModel = grid.getSelectionModel().getSelectedItem();
				
				if(baseModel!=null){
					
					WindowInfoJobsSpecies win = new WindowInfoJobsSpecies();
					win.setWindowTitle((String) baseModel.get(NAME));
					win.setDescription((String) baseModel.get(DESCRIPTION));

					win.show();
				}
				
			}

		});

		menu.add(menuInfo);
		
		
		
		MenuItem menuComputation = new MenuItem(); 
		menuComputation.setId(COMPUTATION);
		menuComputation.setText(COMPUTATION);  
		menuComputation.setIcon(Resources.addOperator());
		
		menuComputation.addSelectionListener(new SelectionListener<MenuEvent>() {

			@Override
			public void componentSelected(MenuEvent ce) {

				BaseModelData baseModel = grid.getSelectionModel().getSelectedItem();
				
				if(baseModel!=null){
					
					String id = baseModel.get(ID);
					
					System.out.println("id " + id);
					Operator operator = (Operator) baseModel.get(id);
					
					System.out.println("operator" + operator);
					OccurrenceApplicationController.getEventBus().fireEvent(new AddComputationPanelEvent(operator));
				
				}
				
			}

		});
		
		menu.add(menuComputation);
		
		grid.setContextMenu(menu);
	
	}
	
	public void enableButtonOnClick(boolean bool){
		this.buttonComputation.setEnabled(bool);
		this.buttonInfo.setEnabled(bool);
	}
	
	
}
