package org.gcube.portlets.user.occurrencemanagement.client.view.panel;



import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence.HeaderOccurrenceMenuItem;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation.CenterComputationPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation.DetailsOperationPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation.GxtBorderLayoutComputationPanel;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.data.CenterDataPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.data.ExplorerDataPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.data.GxtBorderLayoutDataPanel;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.operation.CenterAlgorithmPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.operation.ExplorerOperationPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.operation.GxtBorderLayoutOperationPanel;

import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.CardLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Element;


public class GxtCardLayoutMainPanel extends LayoutContainer{

	private CardLayout cardLayout = new CardLayout();
	
	private ContentPanel activePanel = null;
	
	private GxtBorderLayoutDataPanel borderDataPanel;
	
	private GxtBorderLayoutOperationPanel borderOperationPanel;
	
	private GxtBorderLayoutComputationPanel borderComputationPanel;
	
	public GxtCardLayoutMainPanel(CenterDataPanelMng centerDataPanel, ExplorerDataPanelMng explorerDataPanel, CenterAlgorithmPanelMng operationPanel, ExplorerOperationPanelMng explorerOperationPanel, CenterComputationPanelMng centerComputationPanelMng, DetailsOperationPanelMng detailsOperationManager) {
		instanceDataPanel(centerDataPanel,explorerDataPanel);
		instanceAlgorithmPanel(operationPanel,explorerOperationPanel);
		instanceComputationPanel(centerComputationPanelMng, detailsOperationManager);

	}
	
	private void instanceComputationPanel(CenterComputationPanelMng centerComputationPanelMng, DetailsOperationPanelMng detailsOperationManager) {
		// TODO Auto-generated method stub
		this.borderComputationPanel = new GxtBorderLayoutComputationPanel(centerComputationPanelMng, detailsOperationManager);
		this.borderComputationPanel.setHeaderVisible(false);
		this.borderComputationPanel.setBodyBorder(false);
		
	}

	private void instanceDataPanel(CenterDataPanelMng centerDataPanel, ExplorerDataPanelMng explorerDataPanel){
//		occurrencesLoadedPanel  = new GxtOccurrencesPanel(OCCURRENCES_TABLE);
//		occurrencesResultPanel =  new GxtOccurrencesPanel(OCCURRENCES_TABLE);
		
		this.borderDataPanel = new GxtBorderLayoutDataPanel(centerDataPanel,explorerDataPanel);
		this.borderDataPanel.setHeaderVisible(false);
		this.borderDataPanel.setBodyBorder(false);
		
	}
	
	private void instanceAlgorithmPanel(CenterAlgorithmPanelMng operationPanel, ExplorerOperationPanelMng explorerPanel){
		this.borderOperationPanel = new GxtBorderLayoutOperationPanel(operationPanel, explorerPanel);
		this.borderOperationPanel.setHeaderVisible(false);
		this.borderOperationPanel.setBodyBorder(false);
	}


	@Override
	protected void onRender(Element parent, int pos) {
		super.onRender(parent, pos);
		setLayout(new FitLayout());
	
		ContentPanel cp = new ContentPanel();
		cp.setHeaderVisible(false);
		cp.setBodyBorder(false);
		cp.setLayout(cardLayout);
		
		cp.add(borderDataPanel);
		cp.add(borderOperationPanel);
		cp.add(borderComputationPanel);
		
		cardLayout.setActiveItem(borderDataPanel);
		activePanel = borderDataPanel;
		
		add(cp);

	};
	
	public void setActivePanel(HeaderOccurrenceMenuItem headerItem){
		  
		  if(headerItem.equals(HeaderOccurrenceMenuItem.DATA) ){
			  cardLayout.setActiveItem(borderDataPanel);
			  activePanel = borderDataPanel;
		  }
		  else if(headerItem.equals(HeaderOccurrenceMenuItem.OPERATION)){
			  cardLayout.setActiveItem(borderOperationPanel); 
			  activePanel = borderOperationPanel;
		  }
		  else if(headerItem.equals(HeaderOccurrenceMenuItem.COMPUTATION)){
			  cardLayout.setActiveItem(borderComputationPanel); 
			  borderComputationPanel.refreshProgressSize();
			  activePanel = borderComputationPanel;
		  }
		  
	  }

	public ContentPanel getActivePanel() {
		return activePanel;
	}
	
	
	public void updateHeight(int rootHeight) {
		borderDataPanel.updateHeight(rootHeight);
	}

	public void updateWidth(int rootWidth) {
		borderDataPanel.updateWidth(rootWidth);

	}
}
