package org.gcube.portlets.user.occurrencemanagement.client.rpc;

import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The async counterpart of <code>GreetingService</code>.
 */
public interface OccurrenceManagementServiceAsync {

	void getListOccurrencesSet(ElaborationType elaborationType,boolean onlyNotCompleted,AsyncCallback<List<JobOccurrencesModel>> callback);

//	void importOccurrences(String workspaceItemId, String listOccurrencesName, String description, AsyncCallback<Void> callback);

	void getListOperator(AsyncCallback<List<org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator>> callback);

	void startComputation(Operator operator, String computationTitle, String computationDescription, AsyncCallback<String> asyncCallback);

	void saveSelectedOccurrencePoints(String resourceId,
			ElaborationType elaborationType, String destinationFolderId,
			String fileName, AsyncCallback<Boolean> callback);

	void deleteResourceById(String resourceId, AsyncCallback<Void> callback);
}
