package org.gcube.portlets.user.occurrencemanagement.client.job;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;


public class JobColumnConfig {
	
	
	private boolean statusAsProgress;
	private boolean name;
	private boolean statusAsString;
	private boolean startTime;
	private boolean endTime;
	private ColumnConfig statusColumn;
	private ArrayList<ColumnConfig> listColumnConfig;
	private ColumnConfig statusProgressColumn;
	private boolean type;


	/**
	 * Set display columns
	 * @param name
	 * @param statusAsString
	 * @param statusAsProgress
	 * @param startTime
	 * @param endTime
	 * @param type
	 */
	public JobColumnConfig(boolean name, boolean statusAsString, boolean statusAsProgress, boolean startTime, boolean endTime, boolean type){
		this.name= name;
		this.statusAsString = statusAsString;
		this.startTime = startTime;
		this.endTime = endTime;
		this.statusAsProgress = statusAsProgress;
		this.type = type;
		
		setColumnConfig();
	}
	
	private void setColumnConfig(){

		listColumnConfig = new ArrayList<ColumnConfig>();
		
		if(name)
			listColumnConfig.add(new ColumnConfig(JobOccurrencesModel.JOBNAME, JobOccurrencesModel.JOBNAME, 265));
		
		if(type)
			listColumnConfig.add(new ColumnConfig(JobOccurrencesModel.ELABORATIONTYPE, JobOccurrencesModel.ELABORATIONTYPE, 100));
		
		if(statusAsString){
			statusColumn = new ColumnConfig(JobOccurrencesModel.STATUS, JobOccurrencesModel.STATUS, 180);
			listColumnConfig.add(statusColumn);
		}
		
		if(statusAsProgress){
			statusProgressColumn = new ColumnConfig(JobOccurrencesModel.STATUSPROGESSBAR, JobOccurrencesModel.STATUSPROGESSBAR, 260);
			listColumnConfig.add(statusProgressColumn);
		}
		
		if(startTime)
			listColumnConfig.add(new ColumnConfig(JobOccurrencesModel.STARTTIME, JobOccurrencesModel.STARTTIME, 150));
		
		if(endTime)
			listColumnConfig.add(new ColumnConfig(JobOccurrencesModel.ENDTIME, JobOccurrencesModel.ENDTIME, 150));
	}
	
	

	public boolean isStatusAsProgress() {
		return statusAsProgress;
	}

	public void setStatusAsProgress(boolean statusAsProgress) {
		this.statusAsProgress = statusAsProgress;
	}

	public List<ColumnConfig> getListColumnConfig() {
		return listColumnConfig;
	}

	public ColumnConfig getStatusColumnConfig() {
		return statusColumn;
	}
	
	public ColumnConfig getProgressStatusColumnConfig() {
		return statusProgressColumn;
	}

	public boolean isStatusAsString() {
		return statusAsString;
	}
}
