/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.event;

import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;

import com.google.gwt.event.shared.GwtEvent;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class SaveResourceEvent extends GwtEvent<SaveResourceEventHandler> {
	
	public static final GwtEvent.Type<SaveResourceEventHandler> TYPE = new Type<SaveResourceEventHandler>();
	private String resourceId;
	private String resourceName;
	private ElaborationType elaborationType;

	@Override
	public Type<SaveResourceEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(SaveResourceEventHandler handler) {
		handler.onSaveResource(this);	
	}
	
	public SaveResourceEvent(String resourceId, String resourceName, ElaborationType type) {
		this.resourceId = resourceId;
		this.resourceName = resourceName;
		this.elaborationType = type;
	}

	

	public String getResourceName() {
		return resourceName;
	}

	public String getResourceId() {
		return resourceId;
	}

	public ElaborationType getElaborationType() {
		return elaborationType;
	}

}
