/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.event;

import com.google.gwt.event.shared.GwtEvent;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class OpenTableEvent extends GwtEvent<OpenTableEventHandler> {
	
	public static final GwtEvent.Type<OpenTableEventHandler> TYPE = new Type<OpenTableEventHandler>();
	private String tableId;
	private String listOccurrencesName;


	@Override
	public Type<OpenTableEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(OpenTableEventHandler handler) {
		handler.onOpenTable(this);	
	}
	
	public OpenTableEvent(String tableId, String listOccurrencesName) {
		this.tableId = tableId;
		this.listOccurrencesName = listOccurrencesName;
	}

	public String getTableId() {
		return tableId;
	}

	public String getListOccurrencesName() {
		return listOccurrencesName;
	}

}
