/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.client.templates;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.newsfeed.client.event.AddCommentEvent;
import org.gcube.portlets.user.newsfeed.client.event.EditCommentEvent;
import org.gcube.portlets.user.newsfeed.client.templates.AddCommentTemplate;
import org.gcube.portlets.user.newsfeed.client.templates.SingleComment;
import org.gcube.portlets.user.newsfeed.client.templates.TweetTemplate;

public class AddCommentTemplate
extends Composite {
    private static CommentTemplateUiBinder uiBinder = (CommentTemplateUiBinder)GWT.create(CommentTemplateUiBinder.class);
    private static final String COMMENT_TEXT = "Add a comment ...";
    private static final String ERROR_UPDATE_TEXT = "Looks like empty to me!";
    public static final String avatar_default = String.valueOf(GWT.getModuleBaseURL()) + "../images/Avatar_default.png";
    private TweetTemplate owner;
    private HandlerManager eventBus;
    private boolean isEditing = false;
    private HTMLPanel commentPanel;
    private Comment toEdit;
    @UiField
    HTMLPanel mainPanel;
    @UiField
    Image avatarImage;
    @UiField
    TextArea commentTextArea;
    @UiField
    Button submitButton;
    @UiField
    Button cancelButton;

    public AddCommentTemplate(TweetTemplate caller, UserInfo myUserInfo, HandlerManager eventBus) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.eventBus = eventBus;
        this.owner = caller;
        this.avatarImage.setPixelSize(30, 30);
        this.avatarImage.setUrl(myUserInfo.getAvatarId());
        this.commentTextArea.setPixelSize(450, 26);
        this.commentTextArea.setText(COMMENT_TEXT);
    }

    public AddCommentTemplate(TweetTemplate caller, Comment toEdit, HTMLPanel commentPanel) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.eventBus = caller.getEventBus();
        this.commentPanel = commentPanel;
        this.isEditing = true;
        this.toEdit = toEdit;
        this.owner = caller;
        this.avatarImage.setPixelSize(30, 30);
        this.avatarImage.setUrl(caller.getMyUserInfo().getAvatarId());
        this.commentTextArea.setPixelSize(450, 26);
        this.commentTextArea.setText(new HTML(toEdit.getText()).getText());
        this.mainPanel.removeStyleName("comment-hidden");
        this.mainPanel.setStyleName("single-comment");
        this.commentTextArea.addStyleName("dark-color");
    }

    public void setFocus() {
        this.commentTextArea.setFocus(true);
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        switch (event.getTypeInt()) {
            case 524288: {
                if (!this.commentTextArea.getText().equals(COMMENT_TEXT) && !this.commentTextArea.getText().equals(ERROR_UPDATE_TEXT)) break;
                this.commentTextArea.setText("");
                this.commentTextArea.addStyleName("dark-color");
                this.commentTextArea.removeStyleName("error");
            }
        }
    }

    @UiHandler(value={"submitButton"})
    void onSubmitClick(ClickEvent e) {
        String userComment = this.commentTextArea.getText().trim();
        if (!this.checkTextLength(userComment)) {
            Window.alert((String)"We found a single word containing more than 50 chars and it's not a link, is it meaningful?");
            return;
        }
        if (userComment.equals(COMMENT_TEXT) || userComment.equals(ERROR_UPDATE_TEXT) || userComment.equals("")) {
            this.commentTextArea.addStyleName("error");
            this.commentTextArea.setText(ERROR_UPDATE_TEXT);
            return;
        }
        if (this.isEditing) {
            this.toEdit.setText(this.escapeHtml(this.commentTextArea.getText()));
            this.eventBus.fireEvent((GwtEvent)new EditCommentEvent(this.owner, this.toEdit));
        } else {
            this.eventBus.fireEvent((GwtEvent)new AddCommentEvent(this.owner, this.escapeHtml(this.commentTextArea.getText())));
        }
        this.getWidget().setVisible(false);
        this.owner.setCommentingDisabled(false);
    }

    private boolean checkTextLength(String textToCheck) {
        String[] parts;
        String[] stringArray = parts = textToCheck.split("\\s");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (!item.startsWith("http") && item.length() > 50) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @UiHandler(value={"cancelButton"})
    void onCancelClick(ClickEvent e) {
        this.getWidget().setVisible(false);
        this.owner.setCommentingDisabled(false);
        if (this.isEditing) {
            this.commentPanel.clear();
            SingleComment sc = new SingleComment(this.toEdit, this.owner, true);
            this.commentPanel.add((Widget)sc);
        }
    }

    @UiHandler(value={"commentTextArea"})
    void onCommentClick(ClickEvent e) {
        if (this.commentTextArea.getText().equals(COMMENT_TEXT) || this.commentTextArea.getText().equals(ERROR_UPDATE_TEXT)) {
            this.commentTextArea.setText("");
            this.commentTextArea.addStyleName("dark-color");
            this.commentTextArea.removeStyleName("error");
        }
    }

    @UiHandler(value={"commentTextArea"})
    void onCommentKeyPress(KeyPressEvent e) {
        if (this.commentTextArea.getText().equals(COMMENT_TEXT) || this.commentTextArea.getText().equals(ERROR_UPDATE_TEXT)) {
            this.commentTextArea.setText("");
            this.commentTextArea.addStyleName("dark-color");
            this.commentTextArea.removeStyleName("error");
        }
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

