/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;
import org.gcube.portlets.user.newsfeed.client.NewsService;
import org.gcube.portlets.user.newsfeed.server.CommentNotificationsThread;
import org.gcube.portlets.user.newsfeed.server.LikeNotificationsThread;
import org.gcube.portlets.user.newsfeed.shared.EnhancedFeed;
import org.gcube.portlets.user.newsfeed.shared.UserSettings;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;

public class NewsServiceImpl
extends RemoteServiceServlet
implements NewsService {
    private static GCUBEClientLog _log = new GCUBEClientLog(NewsServiceImpl.class, new Properties[0]);
    private static final String ADMIN_ROLE = "Administrator";
    private static final String SESSION_ADMIN_ATTR = "SESSION_ADMIN_ATTR";
    private static final String USER_SETTINGS_ATTR = "USER_SETTINGS_ATTR";
    private DatabookStore store;
    private boolean withinPortal = false;
    private static final int MAX_FEEDS_NO = 30;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn((Object)"USER IS NULL setting testing user and Running OUTSIDE PORTAL");
            user = "test.user";
            user = "massimiliano.assante";
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
        } else {
            this.withinPortal = true;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public UserSettings getUserSettings() {
        if (this.getUserSettingsFromSession() != null) {
            return this.getUserSettingsFromSession();
        }
        try {
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            String email = String.valueOf(username) + "@isti.cnr.it";
            String fullName = String.valueOf(username) + " FULL";
            String thumbnailURL = "images/Avatar_default.png";
            if (this.withinPortal) {
                User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
                thumbnailURL = "/image/user_male_portrait?img_id=" + user.getPortraitId();
                fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
                email = user.getEmailAddress();
                ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                String accountURL = themeDisplay.getURLMyAccount().toString();
                UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, false, null);
                UserSettings toReturn = new UserSettings(userInfo, this.getFeedsRefreshTimeInMillis(), session.getScopeName(), this.isInfrastructureScope());
                this.setUserSettingsInSession(toReturn);
                return toReturn;
            }
            _log.info((Object)"Returning test USER");
            UserInfo user = new UserInfo(this.getASLSession().getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, null);
            return new UserSettings(user, this.getFeedsRefreshTimeInMillis(), session.getScopeName(), this.isInfrastructureScope());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserSettings();
        }
    }

    private boolean isInfrastructureScope() {
        return this.getASLSession().getScope().isInfrastructure();
    }

    public ArrayList<EnhancedFeed> getAllUpdateUserFeeds(int feedsNoPerCategory) {
        HashMap<String, Feed> feedsMap;
        ArrayList<Feed> toMerge;
        String userName;
        block20: {
            userName = this.getASLSession().getUsername();
            toMerge = new ArrayList<Feed>();
            feedsMap = new HashMap<String, Feed>();
            if (!this.withinPortal) {
                return this.getEclipseResult(userName, false);
            }
            if (userName.compareTo("test.user") != 0) break block20;
            _log.debug((Object)("Found " + userName + " returning nothing"));
            return null;
        }
        try {
            _log.info((Object)("****** retrieving feeds for user: " + userName));
            User currUser = OrganizationsUtil.validateUser((String)userName);
            if (this.isInfrastructureScope()) {
                Iterator<Object> iterator = currUser.getOrganizations().iterator();
                while (iterator.hasNext()) {
                    LiferayGroupManager gm = new LiferayGroupManager();
                    Organization org = (Organization)iterator.next();
                    if (!gm.isVRE(String.valueOf(org.getOrganizationId())).booleanValue()) continue;
                    String vreid = gm.getScope("" + org.getOrganizationId());
                    _log.trace((Object)("Reading feeds for VRE: " + (String)vreid));
                    ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, feedsNoPerCategory);
                    for (Feed feed : OrganizationFeeds) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
                ArrayList userFeeds = (ArrayList)this.store.getRecentFeedsByUser(userName, feedsNoPerCategory);
                for (Feed feed : userFeeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
                ArrayList userFriendsIds = (ArrayList)this.store.getFriends(userName);
                for (String userid : userFriendsIds) {
                    for (Feed feed : this.store.getRecentFeedsByUser(userid, feedsNoPerCategory)) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
                ArrayList portalFeeds = (ArrayList)this.store.getAllPortalPrivacyLevelFeeds();
                for (Feed feed : portalFeeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
            } else {
                String vreid = this.getASLSession().getScopeName();
                _log.trace((Object)("News Feed in VRE, Reading feeds for VRE: " + vreid));
                ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, feedsNoPerCategory * 3);
                for (Feed feed : OrganizationFeeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
            }
            for (String key : feedsMap.keySet()) {
                toMerge.add((Feed)feedsMap.get(key));
            }
            ArrayList<Feed> toReturn = new ArrayList<Feed>();
            if (toMerge.size() > 30) {
                int i = 0;
                while (i < 30) {
                    toReturn.add((Feed)toMerge.get(i));
                    ++i;
                }
            } else {
                return this.enhanceFeeds(toMerge, 2);
            }
            return this.enhanceFeeds(toReturn, 2);
        }
        catch (PrivacyLevelTypeNotFoundException e) {
            _log.error((Object)("Privacy Level not Found " + e.getMessage()));
            e.printStackTrace();
        }
        catch (FeedTypeNotFoundException e) {
            _log.error((Object)("Feed Type not Found " + e.getMessage()));
            e.printStackTrace();
        }
        catch (ColumnNameNotFoundException e) {
            _log.error((Object)("Column name not Found " + e.getMessage()));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ArrayList<EnhancedFeed> getOnlyConnectionsUserFeeds() {
        block11: {
            ArrayList<Feed> toMerge = new ArrayList<Feed>();
            HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
            String userName = this.getASLSession().getUsername();
            try {
                if (!this.withinPortal) {
                    return this.getEclipseResult(userName, true);
                }
                ArrayList userFriendsIds = (ArrayList)this.store.getFriends(userName);
                for (String userid : userFriendsIds) {
                    for (Feed feed : this.store.getRecentFeedsByUser(userid, 10)) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
                for (String key : feedsMap.keySet()) {
                    toMerge.add((Feed)feedsMap.get(key));
                }
                Collections.sort(toMerge, Collections.reverseOrder());
                ArrayList<Feed> toReturn = new ArrayList<Feed>();
                if (toMerge.size() > 30) {
                    int i = 0;
                    while (i < 30) {
                        toReturn.add((Feed)toMerge.get(i));
                        ++i;
                    }
                    break block11;
                }
                return this.enhanceFeeds(toMerge, 2);
            }
            catch (PrivacyLevelTypeNotFoundException e) {
                _log.error((Object)("Privacy Level not Found " + e.getMessage()));
                e.printStackTrace();
            }
            catch (FeedTypeNotFoundException e) {
                _log.error((Object)("Feed Type not Found " + e.getMessage()));
                e.printStackTrace();
            }
            catch (ColumnNameNotFoundException e) {
                _log.error((Object)("Column name not Found " + e.getMessage()));
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public EnhancedFeed getSingleFeed(String feedKey) {
        Feed feed = null;
        try {
            if (feedKey != null && (feed = this.store.readFeed(feedKey)) != null) {
                ArrayList<Feed> toEnhance = new ArrayList<Feed>();
                toEnhance.add(feed);
                return (EnhancedFeed)this.enhanceFeeds(toEnhance, -1).get(0);
            }
        }
        catch (Exception e) {
            _log.debug((Object)("Error while trying to fetch feed with key " + feedKey + " returning nothing"));
            return new EnhancedFeed();
        }
        return new EnhancedFeed();
    }

    private ArrayList<EnhancedFeed> getEclipseResult(String userName, boolean onlyConnections) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Feed> toMerge = new ArrayList<Feed>();
        HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
        ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE("/gcube/devsec/devVRE", 10);
        for (Feed feed : OrganizationFeeds) {
            feedsMap.put(feed.getKey(), feed);
            _log.trace((Object)("Reading desc: " + feed.getDescription()));
        }
        if (!onlyConnections) {
            ArrayList userFeeds = (ArrayList)this.store.getRecentFeedsByUser(userName, 10);
            for (Feed feed : userFeeds) {
                feedsMap.put(feed.getKey(), feed);
            }
            ArrayList portalFeeds = (ArrayList)this.store.getAllPortalPrivacyLevelFeeds();
            for (Feed feed : portalFeeds) {
                feedsMap.put(feed.getKey(), feed);
            }
        }
        ArrayList userFriendsIds = (ArrayList)this.store.getFriends(userName);
        for (String userid : userFriendsIds) {
            for (Feed feed : this.store.getRecentFeedsByUser(userid, 10)) {
                feedsMap.put(feed.getKey(), feed);
            }
        }
        for (String key : feedsMap.keySet()) {
            toMerge.add((Feed)feedsMap.get(key));
        }
        for (Feed feed : toMerge) {
            feed.setThumbnailURL("http://127.0.0.1:8888/images/Avatar_default.png");
        }
        return this.enhanceFeeds(toMerge, 2);
    }

    public ArrayList<EnhancedFeed> getOnlyMyUserFeeds() {
        String userName = this.getASLSession().getUsername();
        _log.trace((Object)("getOnly UserFeeds for " + userName));
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getRecentFeedsByUser(userName, 15);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.enhanceFeeds(userFeeds, 2);
    }

    public ArrayList<EnhancedFeed> getOnlyLikedFeeds() {
        String userName = this.getASLSession().getUsername();
        _log.trace((Object)("getLiked Feeds for " + userName));
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getAllLikedFeedsByUser(userName, 25);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.enhanceFeeds(userFeeds, 2);
    }

    public boolean like(String feedid, String feedText, String feedOwnerId) {
        boolean likeCommitResult = false;
        UserInfo user = this.getUserSettings().getUserInfo();
        Like toLike = new Like(UUID.randomUUID().toString(), user.getUsername(), new Date(), feedid, user.getFullName(), user.getAvatarId());
        try {
            likeCommitResult = this.store.like(toLike);
        }
        catch (FeedIDNotFoundException e) {
            _log.error((Object)("Feed not Found for this like " + e.getMessage()));
            e.printStackTrace();
            return false;
        }
        if (likeCommitResult && !user.getUsername().equals(feedOwnerId)) {
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(this.getASLSession());
            boolean nResult = nm.notifyLikedFeed(feedOwnerId, feedid, this.escapeHtml(feedText));
            _log.trace((Object)("Like Notification added? " + nResult));
        }
        return likeCommitResult;
    }

    public Comment comment(String feedid, String commentText, String feedOwnerId, boolean isAppFeed) {
        boolean commentCommitResult = false;
        _log.trace((Object)("Trying to add this comment " + commentText));
        UserInfo user = this.getUserSettings().getUserInfo();
        Comment comment = new Comment(UUID.randomUUID().toString(), user.getUsername(), new Date(), feedid, this.transformUrls(this.escapeHtml(commentText)), user.getFullName(), user.getAvatarId());
        try {
            if (this.store.addComment(comment)) {
                commentCommitResult = true;
            }
        }
        catch (FeedIDNotFoundException e) {
            _log.error((Object)("Feed not Found for this comment " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
        if (commentCommitResult && this.withinPortal) {
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(this.getASLSession());
            if (!user.getUsername().equals(feedOwnerId) && !isAppFeed) {
                boolean result = nm.notifyOwnCommentReply(feedOwnerId, feedid, this.escapeHtml(commentText));
                _log.trace((Object)("Comment Notification to post owner added? " + result));
            }
            Thread commentsNotificationthread = new Thread((Runnable)new CommentNotificationsThread(this.store, user.getUsername(), comment.getFeedid(), commentText, (NotificationsManager)nm, feedOwnerId));
            commentsNotificationthread.start();
            Thread likesThread = new Thread((Runnable)new LikeNotificationsThread(commentText, (NotificationsManager)nm, this.getAllLikesByFeed(feedid)));
            likesThread.start();
        }
        return comment;
    }

    public Comment editComment(Comment toEdit) {
        UserInfo user = this.getUserSettings().getUserInfo();
        Comment edited = new Comment(toEdit.getKey(), toEdit.getUserid(), new Date(), toEdit.getFeedid(), this.transformUrls(this.escapeHtml(toEdit.getText())), user.getFullName(), user.getAvatarId());
        try {
            this.store.editComment(edited);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return edited;
    }

    private String replaceAmpersand(String toReplace) {
        String toReturn = toReplace.replaceAll("&amp;", "&");
        return toReturn;
    }

    private ArrayList<EnhancedFeed> enhanceFeeds(ArrayList<Feed> toEnhance, int commentsNumberPerFeed) {
        ArrayList<EnhancedFeed> toReturn = new ArrayList<EnhancedFeed>();
        String username = this.getASLSession().getUsername();
        Collections.sort(toEnhance, Collections.reverseOrder());
        ArrayList likedFeeds = (ArrayList)this.store.getAllLikedFeedIdsByUser(this.getASLSession().getUsername());
        for (Feed feed : toEnhance) {
            feed.setDescription(this.replaceAmpersand(feed.getDescription()));
            if (!feed.isApplicationFeed()) {
                feed.setThumbnailURL(this.getUserImagePortraitUrlLocal(feed.getEntityId()));
            }
            boolean liked = likedFeeds.contains(feed.getKey());
            int commentsNo = 0;
            try {
                commentsNo = Integer.parseInt(feed.getCommentsNo());
            }
            catch (NumberFormatException e) {
                commentsNo = 0;
                _log.error((Object)("NumberFormatException while reading comments number " + e.getMessage()));
            }
            if (commentsNo == 0) {
                EnhancedFeed toAdd = null;
                toAdd = feed.isApplicationFeed() ? new EnhancedFeed(feed, liked, this.checkisAdminUser()) : new EnhancedFeed(feed, liked, this.isUsers(feed, username));
                toReturn.add(toAdd);
                continue;
            }
            ArrayList comments = this.getAllCommentsByFeed(feed.getKey());
            Collections.sort(comments);
            int currCommentsNumber = comments.size();
            if (currCommentsNumber < commentsNumberPerFeed || commentsNumberPerFeed == -1) {
                EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, username), comments);
                toReturn.add(toAdd);
                continue;
            }
            ArrayList<Comment> comments2Attach = new ArrayList<Comment>();
            int i = currCommentsNumber - commentsNumberPerFeed;
            while (i < currCommentsNumber) {
                comments2Attach.add((Comment)comments.get(i));
                ++i;
            }
            EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, username), comments2Attach);
            toReturn.add(toAdd);
        }
        _log.trace((Object)("ENHANCED FEEDS TOTAL= " + toReturn.size() + " for user: " + username));
        return toReturn;
    }

    private String getUserImagePortraitUrlLocal(String screenName) {
        if (!this.withinPortal) {
            return "";
        }
        StringBuilder thumbnailURL = new StringBuilder("/image/user_male_portrait?img_id=");
        User user = null;
        try {
            user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)screenName);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return thumbnailURL.append(user.getPortraitId()).toString();
    }

    public ArrayList<Like> getAllLikesByFeed(String feedid) {
        ArrayList toReturn = (ArrayList)this.store.getAllLikesByFeed(feedid);
        _log.trace((Object)("Asking likes for " + feedid));
        for (Like like : toReturn) {
            like.setThumbnailURL(this.getUserImagePortraitUrlLocal(like.getUserid()));
        }
        return toReturn;
    }

    public ArrayList<Comment> getAllCommentsByFeed(String feedid) {
        _log.trace((Object)("Asking comments for " + feedid));
        ArrayList toReturn = (ArrayList)this.store.getAllCommentByFeed(feedid);
        for (Comment comment : toReturn) {
            comment.setThumbnailURL(this.getUserImagePortraitUrlLocal(comment.getUserid()));
        }
        Collections.sort(toReturn);
        return toReturn;
    }

    public boolean deleteComment(String commentid, String feedid) {
        _log.trace((Object)("Attempting to delete comment " + commentid));
        try {
            return this.store.deleteComment(commentid, feedid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteFeed(String feedid) {
        _log.trace((Object)("Attempting to delete feed " + feedid));
        try {
            return this.store.deleteFeed(feedid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private UserSettings getUserSettingsFromSession() {
        try {
            return (UserSettings)this.getASLSession().getAttribute(USER_SETTINGS_ATTR);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private void setUserSettingsInSession(UserSettings user) {
        this.getASLSession().setAttribute(USER_SETTINGS_ATTR, (Object)user);
    }

    private boolean isUsers(Feed tocheck, String username) {
        return tocheck.getEntityId().equals(username);
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private boolean checkisAdminUser() {
        if (this.getASLSession().getAttribute(SESSION_ADMIN_ATTR) == null) {
            boolean isAdmin = false;
            try {
                isAdmin = this.isAdmin();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getASLSession().setAttribute(SESSION_ADMIN_ATTR, (Object)isAdmin);
            return isAdmin;
        }
        return (Boolean)this.getASLSession().getAttribute(SESSION_ADMIN_ATTR);
    }

    private boolean isAdmin() throws PortalException, SystemException {
        User currUser = OrganizationsUtil.validateUser((String)this.getASLSession().getUsername());
        List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        Organization rootOrganization = null;
        for (Organization organization : organizations) {
            if (!organization.getName().equals(OrganizationsUtil.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        try {
            _log.trace((Object)("root: " + rootOrganization.getName()));
            return this.hasRole(ADMIN_ROLE, rootOrganization.getName(), currUser);
        }
        catch (NullPointerException e) {
            _log.error((Object)"Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder");
            return false;
        }
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename) != 0) continue;
            return true;
        }
        return false;
    }

    public String transformUrls(String textToCheck) {
        StringBuilder sb = new StringBuilder();
        String[] parts = textToCheck.split("\\s");
        int i = 0;
        while (i < parts.length) {
            if (parts[i].startsWith("http")) {
                try {
                    URL url = new URL(parts[i]);
                    sb.append("<a class=\"link\" style=\"font-size:11px;\" href=\"").append(url).append("\" target=\"_blank\">").append(url).append("</a> ");
                }
                catch (MalformedURLException e) {
                    _log.error((Object)"MalformedURLException returning... ");
                    return textToCheck;
                }
            } else {
                sb.append(parts[i]);
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString();
    }

    private int getFeedsRefreshTimeInMillis() {
        if (this.withinPortal) {
            _log.info((Object)"Trying to read custom REFRESH_TIME");
            Properties props = new Properties();
            int toReturn = 0;
            int minutes = 0;
            String propertyfile = "";
            try {
                ServletContext servletContext = this.getServletContext();
                String contextPath = servletContext.getRealPath(File.separator);
                propertyfile = String.valueOf(contextPath) + "conf" + File.separator + "settings.properties";
                File propsFile = new File(propertyfile);
                FileInputStream fis = new FileInputStream(propsFile);
                props.load(fis);
                minutes = Integer.parseInt(props.getProperty("REFRESH_TIME"));
                toReturn = minutes * 60 * 1000;
            }
            catch (IOException e) {
                toReturn = 300000;
                _log.error((Object)("settings.properties file not found under " + propertyfile + ", returning 5 minutes"));
                return toReturn;
            }
            catch (ClassCastException ex) {
                toReturn = 300000;
                _log.error((Object)"REFRESH_TIME must be a number (in minutes) returning 5 minutes");
                return toReturn;
            }
            _log.debug((Object)("Returning REFRESH_TIME in millis: " + toReturn + ", (" + minutes + " minutes)"));
            return toReturn;
        }
        return 60000;
    }
}

