/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.my_vres.server;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.KetamaConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DistributedCacheClient {
    private static final Logger logger = LoggerFactory.getLogger(DistributedCacheClient.class);
    private static final String MEMCACHED_RESOURCE_NAME = "Memcached";
    private static final String CATEGORY = "Database";
    private MemcachedClient mClient;
    private static DistributedCacheClient singleton = new DistributedCacheClient();

    private DistributedCacheClient() {
        List addrs = DistributedCacheClient.discoverHostOfServiceEndpoint();
        try {
            this.mClient = new MemcachedClient((ConnectionFactory)new KetamaConnectionFactory(), addrs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DistributedCacheClient getInstance() {
        if (singleton == null) {
            singleton = new DistributedCacheClient();
        }
        return singleton;
    }

    public MemcachedClient getMemcachedClient() {
        return this.mClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<InetSocketAddress> discoverHostOfServiceEndpoint() {
        String currentScope = ScopeProvider.instance.get();
        String infrastructure = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(infrastructure);
        ArrayList<InetSocketAddress> toReturn = new ArrayList<InetSocketAddress>();
        try {
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq 'Memcached'");
            query.addCondition("$resource/Profile/Category/text() eq 'Database'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List ses = client.submit((Query)query);
            if (ses.isEmpty()) {
                logger.error("There is no Memcached cluster having name: Memcached and Category Database on root context in this infrastructure: ");
                List<InetSocketAddress> list = null;
                return list;
            }
            Iterator iterator = ses.iterator();
            if (iterator.hasNext()) {
                ServiceEndpoint se = (ServiceEndpoint)iterator.next();
                Group aps = se.profile().accessPoints();
                for (ServiceEndpoint.AccessPoint ap : aps.asCollection()) {
                    String address = ap.address();
                    String[] splits = address.split(":");
                    String hostname = splits[0];
                    int port = Integer.parseInt(splits[1]);
                    toReturn.add(new InetSocketAddress(hostname, port));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving hosts for the Memcached cluster having name: Memcached and Category Database on root context");
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
        ScopeProvider.instance.set(currentScope);
        return toReturn;
    }
}

