package org.gcube.portlet.user.my_vres.client;


import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

import org.gcube.portlet.user.my_vres.client.widgets.BulletList;
import org.gcube.portlet.user.my_vres.client.widgets.ClickableVRE;
import org.gcube.portlet.user.my_vres.client.widgets.ListItem;
import org.gcube.portlet.user.my_vres.shared.UserBelonging;
import org.gcube.portlet.user.my_vres.shared.VO;
import org.gcube.portlet.user.my_vres.shared.VRE;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
/**
 * 
 * @author Massimiliano Assante - ISTI CNR
 * @version 1.1 Dec 2012
 *
 */
public class VresPanel extends Composite {
	/**
	 * Create a remote service proxy to talk to the server-side service
	 */
	private final MyVREsServiceAsync myVREsService = GWT.create(MyVREsService.class);

	private static String VO = "Organizations";
	private static String VRE = "Groups";
	public static final String COOKIE_NAME = "gCube-EnvironmentViewRestore";
	public static final int COOKIE_MONTHS_EXPIRY_TIME = 6; //6 Months 
	private HTML switcher = new HTML();
	private FlowPanel flowPanel;
	private VerticalPanel mainPanel = new VerticalPanel();
	private HorizontalPanel changeViewPanel = new HorizontalPanel();
	private HorizontalPanel imagesPanel = new HorizontalPanel();
	private Timer t = null;

	private ArrayList<VO> cachedVOs = null;

	private boolean isIconView = true;
	boolean hasVres = false;

	public VresPanel() {
		super();		

		mainPanel.setWidth("100%");
		mainPanel.setStyleName("mainPanel");
		this.flowPanel = new FlowPanel();
		flowPanel.setWidth("100%");
		flowPanel.setStyleName("flowPanel");

		changeViewPanel.setWidth("95%");
		changeViewPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		changeViewPanel.add(imagesPanel);
		initWidget(mainPanel);

		switcher.setStyleName("imageLink");		
		imagesPanel.add(switcher);

		switcher.setStyleName("switcher");
		switcher.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				if (isIconView) 
					showListView();
				else
					showIconView();
			}
		});

		setLastStateUsingCookie();
	}

	private void loadVREs() {		
		myVREsService.getInfrastructureVOs(new AsyncCallback<ArrayList<VO>>() {
			public void onSuccess(ArrayList<VO> result) {
				cachedVOs = result;
				if (isIconView) 
					showIconView();
				else
					showListView();
			}
			public void onFailure(Throwable caught) {
				flowPanel.add(new HTML("Could not fetch personal VREs: " + caught.getMessage()));			
			}
		});
	}

	private void showListView() {
		mainPanel.clear();
		mainPanel.add(changeViewPanel);
		HTML voTitle = new HTML(VO);
		voTitle.setStyleName("listPanel-title");

		BulletList voList = new BulletList();
		voList.setStyleName("list");
		boolean showVOs = false;
		
		for (VO vo: cachedVOs) {
			if (! vo.isRoot() && vo.getUserBelonging() == UserBelonging.BELONGING) {
				voList.add(addVo(vo));
				showVOs = true;
			}	
		}
		if (showVOs){ 
			mainPanel.add(voTitle);
			mainPanel.add(voList);
		}
		HTML vreTitle = new HTML(VRE);
		vreTitle.setStyleName("listPanel-title");

		BulletList vreList = new BulletList();
		vreList.setStyleName("list");
		boolean showVREs = false;

		ArrayList<VRE> sortedVREs = new ArrayList<VRE>();
		for (VO vo: cachedVOs) {
			for (VRE vre : vo.getVres()) {
				sortedVREs.add(vre);
				hasVres = true;
			}
		}
		
		Collections.sort(sortedVREs);
		for (VRE vre : sortedVREs) {
			vreList.add(addVRE(vre));
			showVREs = true;
		}

		if (showVREs) {
			mainPanel.add(vreTitle);
			mainPanel.add(vreList);
		}
		Cookies.setCookie(COOKIE_NAME, "1", getExpiryDate());
		isIconView = false;
		setSwitcherText();
	}

	private void showIconView() {
		mainPanel.clear();
		flowPanel.clear();
		mainPanel.add(changeViewPanel);
		mainPanel.add(flowPanel);

		ArrayList<VRE> sortedVREs = new ArrayList<VRE>();
		for (VO vo: cachedVOs) {
			for (VRE vre : vo.getVres()) {
				sortedVREs.add(vre);
				hasVres = true;
			}
		}
		Collections.sort(sortedVREs);

		for (VRE vre : sortedVREs) {
			ClickableVRE vreButton = new ClickableVRE(vre, myVREsService);
			flowPanel.add(vreButton);
		}

		if (!hasVres) {
			mainPanel.add(new NoVresPanel());
			imagesPanel.clear();
		}
		Cookies.setCookie(COOKIE_NAME, "0", getExpiryDate());
		isIconView = true;
		setSwitcherText();
	}


	private ListItem addVo(final VO vo) {
		final ListItem li = new ListItem();
		li.setStyleName("list-item item-vo ");
		li.setText(vo.getName());
		li.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				showLoading(li);	
				String scope = vo.getGroupName();
				myVREsService.loadLayout(scope,  vo.getFriendlyURL(), new AsyncCallback<Void>() {
					public void onFailure(Throwable arg0) {							
						Window.open( vo.getFriendlyURL(), "_self", "");
					}
					public void onSuccess(Void arg0) {
						Window.open( vo.getFriendlyURL(), "_self", "");
					}
				});				
			}
		});
		return li;
	}

	private ListItem addVRE(final VRE vre) {
		final ListItem li = new ListItem();
		li.setStyleName("list-item item-vre ");
		li.setText(vre.getName());
		li.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				showLoading(li);	
				String scope = vre.getGroupName();
				myVREsService.loadLayout(scope,  vre.getFriendlyURL(), new AsyncCallback<Void>() {
					public void onFailure(Throwable arg0) {							
						Window.open( vre.getFriendlyURL(), "_self", "");
					}
					public void onSuccess(Void arg0) {
						Window.open( vre.getFriendlyURL(), "_self", "");
					}
				});				
			}
		});
		return li;
	}


	private void showLoading(final ListItem li) {
		li.setText("Loading .");	
		t = new Timer() {
			@Override
			public void run() {
				li.setText(li.getText() + " .");
				t.schedule(250);
				if (li.getText().length() > 50)
					t.cancel();
			}
		};
		t.schedule(250);
	}

	private void setSwitcherText() {
		if (isIconView)
			switcher.setHTML("SHOW LIST");
		else
			switcher.setHTML("SHOW TILES");
	}


	/**
	 * 
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public Date getExpiryDate() {
		Date expiryDate = new Date();		
		int month = expiryDate.getMonth();
		month += COOKIE_MONTHS_EXPIRY_TIME ;
		expiryDate.setMonth(month);		
		return expiryDate;
	}
	/**
	 * 
	 */
	private void setLastStateUsingCookie() {
		Date expiryDate = getExpiryDate();

		if (Cookies.getCookie(COOKIE_NAME) == null) {
			Cookies.setCookie(COOKIE_NAME, "0", expiryDate);
		}
		else {
			String lastIconsState = Cookies.getCookie(COOKIE_NAME);
			if (lastIconsState.compareTo("1") == 0) 
				isIconView = false;
			else
				isIconView = true;	
		}
		loadVREs();		
	}
}
