package org.gcube.portlets.user.messages.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.gcube.portlets.user.messages.client.alert.InfoDisplay;
import org.gcube.portlets.user.messages.client.alert.MessageBoxAlert;
import org.gcube.portlets.user.messages.client.event.DeleteMessageEvent;
import org.gcube.portlets.user.messages.client.event.DeleteMessageEventHandler;
import org.gcube.portlets.user.messages.client.event.FileDownloadEvent;
import org.gcube.portlets.user.messages.client.event.FileDownloadEvent.DownloadType;
import org.gcube.portlets.user.messages.client.event.FileDownloadEventHandler;
import org.gcube.portlets.user.messages.client.event.GetAllNewMessagesEvent;
import org.gcube.portlets.user.messages.client.event.GetAllNewMessagesEventHandler;
import org.gcube.portlets.user.messages.client.event.GridMessageSelectedEvent;
import org.gcube.portlets.user.messages.client.event.GridMessageSelectedEventHandler;
import org.gcube.portlets.user.messages.client.event.GridMessageUnSelectedEvent;
import org.gcube.portlets.user.messages.client.event.GridMessageUnSelectedEventHandler;
import org.gcube.portlets.user.messages.client.event.LoadMessagesEvent;
import org.gcube.portlets.user.messages.client.event.LoadMessagesEventHandler;
import org.gcube.portlets.user.messages.client.event.MarkMessageEvent;
import org.gcube.portlets.user.messages.client.event.MarkMessageEventHandler;
import org.gcube.portlets.user.messages.client.event.OpenMessageEvent;
import org.gcube.portlets.user.messages.client.event.OpenMessageEvent.OpenType;
import org.gcube.portlets.user.messages.client.event.OpenMessageEventHandler;
import org.gcube.portlets.user.messages.client.event.PreviewMessageEvent;
import org.gcube.portlets.user.messages.client.event.PreviewMessageEventHandler;
import org.gcube.portlets.user.messages.client.event.SaveAttachmentsEvent;
import org.gcube.portlets.user.messages.client.event.SaveAttachmentsEventHandler;
import org.gcube.portlets.user.messages.client.event.SendMessageEvent;
import org.gcube.portlets.user.messages.client.event.SendMessageEventHandler;
import org.gcube.portlets.user.messages.client.interfaces.EventsTypeEnum;
import org.gcube.portlets.user.messages.client.interfaces.GuiEventInterface;
import org.gcube.portlets.user.messages.client.interfaces.SubscriberInterface;
import org.gcube.portlets.user.messages.client.rpc.MessagesService;
import org.gcube.portlets.user.messages.client.rpc.MessagesServiceAsync;
import org.gcube.portlets.user.messages.client.view.GxtBorderLayoutMainPanel;
import org.gcube.portlets.user.messages.client.view.message.GxtGridMessagesFilterPanel;
import org.gcube.portlets.user.messages.shared.FileModel;
import org.gcube.portlets.user.messages.shared.GXTCategoryItemInterface;
import org.gcube.portlets.user.messages.shared.MessageModel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class MessagesApplicationController{
	private final static HandlerManager eventBus = new HandlerManager(null);
	private MessagesMainPanel mainPanel;
	private HashMap<EventsTypeEnum, ArrayList<SubscriberInterface>> subscribers = null;
	private MessagesApplicationSubscriber messagesSubscriber;
	
	
	/**
	 * Create a remote service proxy to talk to the server-side Greeting service.
	 */
	public final static MessagesServiceAsync rpcMessagesManagementService = GWT.create(MessagesService.class);
	protected static final int DELAY = 10000;

	public MessagesApplicationController() {
		subscribers = new HashMap<EventsTypeEnum, ArrayList<SubscriberInterface>>(); 
		bind();
	}

	public static HandlerManager getEventBus() {
		return eventBus;
	}
	
	public GxtGridMessagesFilterPanel getMessagesPanelContainer() {
		return mainPanel.getMessagesPanelContainer();
	}

	private void bind() {

		eventBus.addHandler(GetAllNewMessagesEvent.TYPE, new GetAllNewMessagesEventHandler() {
			
			@Override
			public void onNewMessagesEvent(GetAllNewMessagesEvent newMessagesEvent) {
			
				FileModel currentSelection = mainPanel.getMessagesPanel().getCurrentSelection(); 
				
				if(currentSelection!=null){
					if(currentSelection.getIdentifier().equals(GXTCategoryItemInterface.MS_MESSAGES) || currentSelection.getIdentifier().equals(GXTCategoryItemInterface.MS_RECEIVED)) 
						mainPanel.getMessagesPanel().setSelect(GXTCategoryItemInterface.MS_RECEIVED);
					else if(currentSelection.getIdentifier().equals(GXTCategoryItemInterface.MS_SENT))	
						mainPanel.getMessagesPanel().setSelect(GXTCategoryItemInterface.MS_SENT);
					}
				else
					mainPanel.getMessagesPanel().setSelect(GXTCategoryItemInterface.MS_RECEIVED); //DEFAULT SELECTION RECEIVED MESSAGES
			}
		});
		
		eventBus.addHandler(GridMessageSelectedEvent.TYPE, new GridMessageSelectedEventHandler() {

			@Override
			public void onGridMessageSelected(GridMessageSelectedEvent gridMessageSelectedEvent) {
				mainPanel.getToolBarMessage().activeButtonsOnSelect(true);

			}
		});

		eventBus.addHandler(GridMessageUnSelectedEvent.TYPE, new GridMessageUnSelectedEventHandler() {

			@Override
			public void onGridMessageUnSelected(GridMessageUnSelectedEvent gridMessageUnSelectedEvent) {
				mainPanel.getToolBarMessage().activeButtonsOnSelect(false);

			}
		});
		
		eventBus.addHandler(MarkMessageEvent.TYPE, new MarkMessageEventHandler() {
			
			@Override
			public void onMark(MarkMessageEvent markAsReadMessageEvent) {
				doMarkAsRead(markAsReadMessageEvent);
				
			}

			private void doMarkAsRead(final MarkMessageEvent markAsReadMessageEvent) {
				
				rpcMessagesManagementService.markMessage(markAsReadMessageEvent.getMessageTarget().getId(), markAsReadMessageEvent.getMessageTarget().getMessageType(), markAsReadMessageEvent.getBoolMark(), markAsReadMessageEvent.getMarkTypeToString(), new AsyncCallback<Boolean>() {

					@Override
					public void onFailure(Throwable caught) {
						new MessageBoxAlert("Error", "Sorry - mark message error - " + caught.getMessage(), null);
						
					}

					@Override
					public void onSuccess(Boolean result) {
						if(result)
							notifySubscriber(markAsReadMessageEvent);
						
					}
				});
				
			}
		});
		
		eventBus.addHandler(DeleteMessageEvent.TYPE, new DeleteMessageEventHandler() {
			
			@Override
			public void onDeleteMessage(DeleteMessageEvent deleteMessageEvent) {
				doDeleteMessage(deleteMessageEvent);
				
			}

			private void doDeleteMessage(final DeleteMessageEvent deleteMessageEvent) {
				
				rpcMessagesManagementService.deleteMessage(deleteMessageEvent.getMessageTarget().getId(), deleteMessageEvent.getMessageTarget().getMessageType(), new AsyncCallback<Boolean>() {

					@Override
					public void onFailure(Throwable caught) {
						new MessageBoxAlert("Error", "Sorry - delete message error - " + caught.getMessage(), null);
						
					}

					@Override
					public void onSuccess(Boolean result) {
						if(result)
							notifySubscriber(deleteMessageEvent);
						
					}
				});
				
				
			}
		});
		
		eventBus.addHandler(FileDownloadEvent.TYPE, new FileDownloadEventHandler() {
			
			@Override
			public void onFileDownloadEvent(FileDownloadEvent fileDownloadEvent) {
			
				if(fileDownloadEvent.getItemIdentifier()!=null){
					if(fileDownloadEvent.getDownloadType().equals(DownloadType.SHOW)){
						if(fileDownloadEvent.getItemName()!= null)
							com.google.gwt.user.client.Window.open(ConstantsPortletMessages.DOWNLOAD_WORKSPACE_SERVICE+"?id="+fileDownloadEvent.getItemIdentifier()+"&viewContent=true", fileDownloadEvent.getItemName(), "");
					}
					else
						com.google.gwt.user.client.Window.open(ConstantsPortletMessages.DOWNLOAD_WORKSPACE_SERVICE+"?id="+fileDownloadEvent.getItemIdentifier(), "_self", "");
				}
			}
		});
		
		eventBus.addHandler(SaveAttachmentsEvent.TYPE, new SaveAttachmentsEventHandler() {
			
			@Override
			public void onSaveAttachments(SaveAttachmentsEvent saveAttachmentsEvent) {
				
				final InfoDisplay saving = new InfoDisplay("Info","saving in progress...");

				rpcMessagesManagementService.saveAttachments(saveAttachmentsEvent.getMessageIdentifier(), saveAttachmentsEvent.getMessageType(), new AsyncCallback<Boolean>() {

					@Override
					public void onFailure(Throwable caught) {
						new MessageBoxAlert("Error", "Sorry - save attachments error - " + caught.getMessage(), null);
						
					}

					@Override
					public void onSuccess(Boolean result) {
						
						if(saving.isAttached())
							saving.hide();
						
						if(result){
							new InfoDisplay("Info","Message attachments has been saved");
//							explorerPanel.getAsycTreePanel().removeAllAndRecoveryRoot();
						}	
					}
				});
			}
		});
		
		eventBus.addHandler(PreviewMessageEvent.TYPE, new PreviewMessageEventHandler() {
			
			@Override
			public void onPreviewMessage(PreviewMessageEvent previewMessageEvent) {
				doPreviewMessage(previewMessageEvent);
				
			}

			private void doPreviewMessage(final PreviewMessageEvent previewMessageEvent) {
				
				rpcMessagesManagementService.getMessageById(previewMessageEvent.getMessageIdentifier(), previewMessageEvent.getMessageType(), new AsyncCallback<MessageModel>() {

					@Override
					public void onFailure(Throwable caught) {
						new MessageBoxAlert("Error", "Sorry - open message error - " + caught.getMessage(), null);
						
					}

					@Override
					public void onSuccess(MessageModel message) {
												
//						String headerTitle = ConstantsExplorer.MESSAGE_SENT_IN_DATE  +": " +message.getDate() + " by "+ message.getFromLogin();
//						new SendMessage(result.getId(), headerTitle, result.getSubject(), result.getTextMessage(), result.getListAttachments(), result.getListContactsToString());
						
						previewMessageEvent.setMessage(message);
						notifySubscriber(previewMessageEvent);
						
					}
				});
				
			}
		});
		
		eventBus.addHandler(OpenMessageEvent.TYPE, new OpenMessageEventHandler() {
			
			@Override
			public void onOpenMessage(OpenMessageEvent openMessageEvent) {
				doOpenMessage(openMessageEvent);
				
			}

			private void doOpenMessage(final OpenMessageEvent openMessageEvent) {
				
				rpcMessagesManagementService.getMessageById(openMessageEvent.getMessageIdentifier(), openMessageEvent.getMessageType(), new AsyncCallback<MessageModel>() {

					@Override
					public void onFailure(Throwable caught) {
						new MessageBoxAlert("Error", "Sorry - open message error - " + caught.getMessage(), null);
						
					}

					@Override
					public void onSuccess(MessageModel result) {

						//Commented for Massi
//						if(openMessageEvent.getOpenType().equals(OpenType.REPLY))
////							new SendMessage(result, MessageOperationType.OPEN); //OPEN MESSAGE
////							notifySubscriber(openMessageEvent);
//						else{
//							openMessageEvent.setMessage(result);
////							notifySubscriber(openMessageEvent);
////							new SendMessage(result, MessageOperationType.FORWARD);
//						}
						
						openMessageEvent.setMessage(result); //This fill item text and list contact
						notifySubscriber(openMessageEvent);
					}
				});
				
				
				
			}
		});
		
		
		eventBus.addHandler(LoadMessagesEvent.TYPE, new LoadMessagesEventHandler() {
			
			@Override
			public void onLoadMessages(LoadMessagesEvent loadMessagesEvent) {
				doGetMessages(loadMessagesEvent);
			
			}

			private void doGetMessages(LoadMessagesEvent loadMessagesEvent) {
				
				FileModel currentSelection = mainPanel.getMessagesPanel().getCurrentSelection(); 
				
				//Control on polling event
				if(loadMessagesEvent.isPolling()){
					if(currentSelection!=null) {
						if(currentSelection.getIdentifier().equals(GXTCategoryItemInterface.MS_MESSAGES) || currentSelection.getIdentifier().equals(GXTCategoryItemInterface.MS_RECEIVED))
							mainPanel.getMessagesPanel().setSelect(GXTCategoryItemInterface.MS_RECEIVED); //notify subscriber after select menu item
					}
					else
						mainPanel.getMessagesPanel().setSelect(GXTCategoryItemInterface.MS_RECEIVED); //notify subscriber after select menu item

					return; //not notify subscriber (notify subscriber after select item of context menu inbox)
				}
				
				
				//update counter messages
				rpcMessagesManagementService.getNewMessagesReceived(new AsyncCallback<List<MessageModel>>() {
						
						@Override
						public void onSuccess(List<MessageModel> result) {
							
							PollingWorkspace.setCounterNotOpenMessages(result.size()); //update current counter
							
						}
						
						@Override
						public void onFailure(Throwable caught) {
							System.out.println("Failure rpc get new message/s");
							
						}
					});
			
				notifySubscriber(loadMessagesEvent);
				
			}
		});
		
		eventBus.addHandler(SendMessageEvent.TYPE, new SendMessageEventHandler() {
			
			@Override
			public void onSendMessage(SendMessageEvent sendMessageEvent) {
				notifySubscriber(sendMessageEvent);
			}
		});

	}
	
	//Method Notify Subscriber
    public void notifySubscriber(GuiEventInterface event){
        if (subscribers.containsKey(event.getKey()))
            for (SubscriberInterface sub : subscribers.get(event.getKey())){
            
            	if(event instanceof LoadMessagesEvent){
        		
            		LoadMessagesEvent loadMessagesEvent = (LoadMessagesEvent) event;
            		
            		if(loadMessagesEvent.getTypeMessages().equals(GXTCategoryItemInterface.MS_SENT)){
//            			System.out.println("GXTCategoryItemInterface.MS_SENT");
            			sub.loadSentMessages();
            		}
            		else{
//            			System.out.println("GXTCategoryItemInterface.MS_RECEIVED");
            			sub.loadReceivedMessages();
            		}
        		
            	}else if(event instanceof DeleteMessageEvent){
            		
            		DeleteMessageEvent deleteMessage = (DeleteMessageEvent) event;
        		
            		sub.deleteMessage(deleteMessage.getMessageTarget().getId());
        		
            	}else if(event instanceof MarkMessageEvent){
            		
            		MarkMessageEvent mark = (MarkMessageEvent) event;
        		
            		sub.markAsReadMessage(mark.getMessageTarget().getId(), mark.getBoolMark());
        		
            	}else if(event instanceof PreviewMessageEvent){
            		
            		PreviewMessageEvent messageEvent = (PreviewMessageEvent) event;

//            		sub.updatePrevieMessage(messageEvent.getMessage().getFromLogin(), messageEvent.getMessage().getSubject(), messageEvent.getMessage().getDate(), messageEvent.getMessage().getTextMessage(), messageEvent.getMessage().getListAttachments());
            		
            		if(messageEvent.getMessageType().equals(GXTCategoryItemInterface.MS_SENT))
            			sub.updatePrevieMessage(messageEvent.getMessage());
            		else
            			sub.updatePrevieMessage(messageEvent.getMessage());
        		
            	}else if(event instanceof SendMessageEvent){
            		
            		SendMessageEvent messageEvent = (SendMessageEvent) event;

//            		sub.updatePrevieMessage(messageEvent.getMessage().getFromLogin(), messageEvent.getMessage().getSubject(), messageEvent.getMessage().getDate(), messageEvent.getMessage().getTextMessage(), messageEvent.getMessage().getListAttachments());
            		
            		HashMap<String, String> hashFiles = new HashMap<String, String>();
            		
            		if(messageEvent.getListFileModelSelected()!=null){
	            		for (FileModel fileModel : messageEvent.getListFileModelSelected()) {
	            			hashFiles.put(fileModel.getIdentifier(), fileModel.getName());
						}
            		}
            		
            		sub.createNewMessage(hashFiles); 	
	        	}else if(event instanceof OpenMessageEvent){
	        		
	        		OpenMessageEvent messageEvent = (OpenMessageEvent) event;
	
	//        		sub.updatePrevieMessage(messageEvent.getMessage().getFromLogin(), messageEvent.getMessage().getSubject(), messageEvent.getMessage().getDate(), messageEvent.getMessage().getTextMessage(), messageEvent.getMessage().getListAttachments());
	        		
	        		MessageModel message = messageEvent.getMessage();
	        		
	        		if(messageEvent.getOpenType().equals(OpenType.FORWARD)){
	        			
		        		HashMap<String, String> hashAttachs = new HashMap<String, String>();
	            		
	            		if(message.getListAttachments()!=null){
		            		for (FileModel fileModel : message.getListAttachments()) {
		            			hashAttachs.put(fileModel.getIdentifier(), fileModel.getName());
							}
	            		}
	
		        		sub.forwardMessage(message.getFromLogin(), message.getSubject(), message.getListContactsToString(), message.getDate(), hashAttachs, message.getTextMessage());
		        		
	        		}else if(messageEvent.getOpenType().equals(OpenType.REPLY)){
	        			sub.replyMessage(message.getFromLogin(), message.getSubject(), new ArrayList<String>(), message.getDate(), message.getTextMessage());
	        			
	        		}else if(messageEvent.getOpenType().equals(OpenType.REPLYALL)){
	        			
	        			sub.replyMessage(message.getFromLogin(), message.getSubject(), message.getListContactsToString(), message.getDate(), message.getTextMessage());
	        		}
	        		
	        	}
            	
            	
            }
               
    }
	
	/**
	 * init method
	 * @param rootPanel
	 */
	public void go(final HasWidgets rootPanel) {
		
		this.mainPanel = new MessagesMainPanel();
		rootPanel.add(this.mainPanel.getBorderLayoutContainer());
//		this.jobManager = JobManager.getInstance();
		initApplication();
		

	}


	public GxtBorderLayoutMainPanel getMainPanel(){
		return this.mainPanel.getBorderLayoutContainer();
	}
	
	private void initApplication(){
		
//		PollingWorkspace.pollReceivedMessages(-1, 20000); //the parameter -1 force (first) synchronization with HL
		
		this.messagesSubscriber = new MessagesApplicationSubscriber(this);
		
		//DEFAULT SELECT
		mainPanel.getMessagesPanel().setSelect(GXTCategoryItemInterface.MS_RECEIVED);
	
	}
	
	public void subscribe(SubscriberInterface subscriber, EventsTypeEnum[] keys)
    {
        for (EventsTypeEnum m : keys)
            subscribe(subscriber, m);
    }

    public void subscribe(SubscriberInterface subscriber, EventsTypeEnum key)
    {
        if (subscribers.containsKey(key))
            subscribers.get(key).add(subscriber);
        else
        {
            ArrayList<SubscriberInterface> subs = new ArrayList<SubscriberInterface>();
            subs.add(subscriber);
            subscribers.put(key, subs);
        }
    }

    public void unsubscribe(SubscriberInterface subscriber, EventsTypeEnum key)
    {
        if (subscribers.containsKey(key))
            subscribers.get(key).remove(subscriber);
    }

}
