/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.messages.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourceBrokenLinkException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourcePluginNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.util.Extensions;
import org.gcube.portlets.user.homelibrary.util.MimeTypeUtil;
import org.gcube.portlets.user.homelibrary.util.zip.ZipUtil;
import org.gcube.portlets.user.messages.server.DownloadServlet;
import org.gcube.portlets.user.messages.server.util.SessionUtil;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = -8423345575690165644L;
    public static Logger logger = Logger.getLogger(DownloadServlet.class);

    public void init() throws ServletException {
        super.init();
        System.out.println("Workspace DownloadServlet ready.");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        WorkspaceItem item;
        String itemId = req.getParameter("id");
        boolean viewContent = req.getParameter("viewContent") == null ? false : req.getParameter("viewContent").equals("true");
        System.out.println("FILE REQUEST " + itemId);
        Workspace wa = null;
        try {
            wa = SessionUtil.getWorkspace((HttpSession)req.getSession());
        }
        catch (Exception e) {
            resp.sendError(500, "Error during workspace retrieving");
            return;
        }
        if (wa == null) {
            resp.sendError(500, "Error, no workspace in session");
            return;
        }
        try {
            item = wa.getItem(itemId);
        }
        catch (ItemNotFoundException e) {
            logger.error((Object)("Requested item " + itemId + " not found"), (Throwable)e);
            resp.sendError(500, "Error, no items found");
            return;
        }
        switch (1.$SwitchMap$org$gcube$portlets$user$homelibrary$home$workspace$WorkspaceItemType[item.getType().ordinal()]) {
            case 1: {
                try {
                    File tmpZip = ZipUtil.zipFolder((WorkspaceFolder)((WorkspaceFolder)item));
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + item.getName() + ".zip\"");
                    resp.setContentType("application/zip");
                    resp.setContentLength((int)tmpZip.length());
                    ServletOutputStream out = resp.getOutputStream();
                    IOUtils.copy((InputStream)new FileInputStream(tmpZip), (OutputStream)resp.getOutputStream());
                    out.close();
                    tmpZip.delete();
                    return;
                }
                catch (InternalErrorException e) {
                    logger.error((Object)("Error during folder compression " + itemId), (Throwable)e);
                    resp.sendError(500, "Error during folder compression: " + e.getMessage());
                    return;
                }
            }
            case 2: {
                FolderItem folderItem = (FolderItem)item;
                switch (1.$SwitchMap$org$gcube$portlets$user$homelibrary$home$workspace$folder$FolderItemType[folderItem.getFolderItemType().ordinal()]) {
                    case 1: {
                        try {
                            ReportTemplate reportTemplate = (ReportTemplate)folderItem;
                            String itemName = item.getName() + "." + Extensions.REPORT_TEMPLATE;
                            String contentDisposition = viewContent ? "inline" : "attachment";
                            resp.setHeader("Content-Disposition", contentDisposition + "; filename=\"" + itemName + "\"");
                            resp.setContentType("application/zip");
                            resp.setContentLength((int)reportTemplate.getLength());
                            ServletOutputStream out = resp.getOutputStream();
                            IOUtils.copy((InputStream)reportTemplate.getData(), (OutputStream)resp.getOutputStream());
                            out.close();
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during external item sending " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                        return;
                    }
                    case 2: {
                        try {
                            Report report = (Report)folderItem;
                            String itemName = item.getName() + "." + Extensions.REPORT;
                            String contentDisposition = viewContent ? "inline" : "attachment";
                            resp.setHeader("Content-Disposition", contentDisposition + "; filename=\"" + itemName + "\"");
                            resp.setContentType("application/zip");
                            resp.setContentLength((int)report.getLength());
                            ServletOutputStream out = resp.getOutputStream();
                            IOUtils.copy((InputStream)report.getData(), (OutputStream)resp.getOutputStream());
                            out.close();
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during external item sending " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                        return;
                    }
                    case 3: 
                    case 4: {
                        try {
                            ExternalFile externalFile = (ExternalFile)folderItem;
                            String mimeType = externalFile.getMimeType();
                            String itemName = MimeTypeUtil.getNameWithExtension((String)item.getName(), (String)mimeType);
                            String contentDisposition = viewContent ? "inline" : "attachment";
                            resp.setHeader("Content-Disposition", contentDisposition + "; filename=\"" + itemName + "\"");
                            resp.setContentType(externalFile.getMimeType());
                            resp.setContentLength((int)externalFile.getLength());
                            ServletOutputStream out = resp.getOutputStream();
                            IOUtils.copy((InputStream)externalFile.getData(), (OutputStream)resp.getOutputStream());
                            out.close();
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during external item sending " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                        return;
                    }
                    case 5: {
                        try {
                            ExternalImage externalImage = (ExternalImage)folderItem;
                            String mimeType = externalImage.getMimeType();
                            String itemName = MimeTypeUtil.getNameWithExtension((String)item.getName(), (String)mimeType);
                            String contentDisposition = viewContent ? "inline" : "attachment";
                            resp.setHeader("Content-Disposition", contentDisposition + "; filename=\"" + itemName + "\"");
                            resp.setContentType(externalImage.getMimeType());
                            resp.setContentLength((int)externalImage.getLength());
                            ServletOutputStream out = resp.getOutputStream();
                            IOUtils.copy((InputStream)externalImage.getData(), (OutputStream)resp.getOutputStream());
                            out.close();
                            return;
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during item compression " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                    }
                    case 6: {
                        try {
                            ExternalUrl externalUrl = (ExternalUrl)folderItem;
                            resp.setContentType("text/uri-list");
                            resp.setContentLength((int)externalUrl.getLength());
                            ServletOutputStream out = resp.getOutputStream();
                            IOUtils.copy((Reader)new StringReader(externalUrl.getUrl()), (OutputStream)resp.getOutputStream());
                            out.close();
                            return;
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during item compression " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                    }
                    case 7: {
                        Query query = (Query)folderItem;
                        resp.setContentType("text/plain");
                        try {
                            resp.setContentLength((int)query.getLength());
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error getting item lenght " + query), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                        ServletOutputStream out = resp.getOutputStream();
                        IOUtils.copy((Reader)new StringReader(query.getQuery()), (OutputStream)resp.getOutputStream());
                        out.close();
                        return;
                    }
                    case 8: {
                        try {
                            TimeSeries ts = (TimeSeries)folderItem;
                            File tmpZip = ZipUtil.zipTimeSeries((TimeSeries)ts);
                            String contentDisposition = viewContent ? "inline" : "attachment";
                            resp.setHeader("Content-Disposition", contentDisposition + "; filename=\"" + item.getName() + ".zip\"");
                            resp.setContentType("application/zip");
                            resp.setContentLength((int)tmpZip.length());
                            ServletOutputStream out = resp.getOutputStream();
                            IOUtils.copy((InputStream)new FileInputStream(tmpZip), (OutputStream)resp.getOutputStream());
                            out.close();
                            tmpZip.delete();
                            return;
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during item compression " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                    }
                    case 9: {
                        try {
                            AquaMapsItem aquamaps = (AquaMapsItem)folderItem;
                            File tmpZip = ZipUtil.zipAquaMapsItem((AquaMapsItem)aquamaps);
                            String contentDisposition = viewContent ? "inline" : "attachment";
                            resp.setHeader("Content-Disposition", contentDisposition + "; filename=\"" + item.getName() + ".zip\"");
                            resp.setContentType("application/zip");
                            resp.setContentLength((int)tmpZip.length());
                            ServletOutputStream out = resp.getOutputStream();
                            IOUtils.copy((InputStream)new FileInputStream(tmpZip), (OutputStream)resp.getOutputStream());
                            out.close();
                            tmpZip.delete();
                            return;
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during item compression " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        try {
                            Document document = (Document)item;
                            if (!viewContent) {
                                File tmpZip = ZipUtil.zipDocument((Document)document);
                                resp.setHeader("Content-Disposition", "attachment; filename=\"" + item.getName() + ".zip\"");
                                resp.setContentType("application/zip");
                                resp.setContentLength((int)tmpZip.length());
                                ServletOutputStream out = resp.getOutputStream();
                                IOUtils.copy((InputStream)new FileInputStream(tmpZip), (OutputStream)resp.getOutputStream());
                                out.close();
                                tmpZip.delete();
                            } else {
                                String mimeType = document.getMimeType();
                                String itemName = MimeTypeUtil.getNameWithExtension((String)item.getName(), (String)mimeType);
                                resp.setHeader("Content-Disposition", "inline; filename=\"" + itemName + "\"");
                                resp.setContentType(document.getMimeType());
                                resp.setContentLength((int)document.getLength());
                                ServletOutputStream out = resp.getOutputStream();
                                IOUtils.copy((InputStream)document.getData(), (OutputStream)resp.getOutputStream());
                                out.close();
                            }
                            return;
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during item compression " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                    }
                    case 14: {
                        try {
                            Metadata document = (Metadata)item;
                            resp.setContentType("text/html");
                            resp.setContentLength((int)document.getLength());
                            ServletOutputStream out = resp.getOutputStream();
                            IOUtils.copy((Reader)new StringReader(document.getData()), (OutputStream)resp.getOutputStream());
                            out.close();
                            return;
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during item compression " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                    }
                    case 15: {
                        try {
                            ExternalResourceLink externalResourceLink = (ExternalResourceLink)folderItem;
                            ServletOutputStream out = resp.getOutputStream();
                            try {
                                String mimeType = externalResourceLink.getMimeType();
                                if (mimeType == null) {
                                    System.out.println("mimeType is null... recover from MimeTypeUtil by BufferedInputStream");
                                    BufferedInputStream bufferedStream = new BufferedInputStream(externalResourceLink.getData(), (int)externalResourceLink.getLength());
                                    mimeType = MimeTypeUtil.getMimeType((InputStream)bufferedStream);
                                }
                                System.out.println("setContentType with mimeType " + mimeType);
                                String itemName = MimeTypeUtil.getNameWithExtension((String)item.getName(), (String)mimeType);
                                String contentDisposition = viewContent ? "inline" : "attachment";
                                resp.setHeader("Content-Disposition", contentDisposition + "; filename=\"" + itemName + "\"");
                                resp.setContentType(mimeType);
                                System.out.println("resoure link lenght: " + externalResourceLink.getLength());
                                resp.setContentLength((int)externalResourceLink.getLength());
                                if (externalResourceLink.getData() != null) {
                                    System.out.println("Input stream is not null");
                                    IOUtils.copy((InputStream)externalResourceLink.getData(), (OutputStream)resp.getOutputStream());
                                } else {
                                    logger.error((Object)("Input stream is null " + itemId));
                                    resp.sendError(500, "Error during inpunt stream retrieving, it's null");
                                }
                            }
                            catch (ExternalResourceBrokenLinkException e) {
                                logger.error((Object)("Error during link resource retrieving " + itemId), (Throwable)e);
                                resp.sendError(500, "Error during link retrieving, link broken!: " + e.getMessage());
                            }
                            catch (ExternalResourcePluginNotFoundException e) {
                                logger.error((Object)("Error during link resource retrieving " + itemId), (Throwable)e);
                                resp.sendError(500, "Error during link retrieving, plugin not found!: " + e.getMessage());
                            }
                            out.close();
                        }
                        catch (InternalErrorException e) {
                            logger.error((Object)("Error during external item sending " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during data retrieving: " + e.getMessage());
                            return;
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error during resource retrieving " + itemId), (Throwable)e);
                            resp.sendError(500, "Error during resource retrieving, plugin not found!: " + e.getMessage());
                            e.printStackTrace();
                        }
                        return;
                    }
                }
            }
        }
        resp.sendError(500, "Error during data retrieving");
    }
}

