/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.messages.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.portlets.user.messages.client.MessagesApplicationSubscriber;
import org.gcube.portlets.user.messages.client.MessagesMainPanel;
import org.gcube.portlets.user.messages.client.event.DeleteMessageEvent;
import org.gcube.portlets.user.messages.client.event.FileDownloadEvent;
import org.gcube.portlets.user.messages.client.event.GetAllNewMessagesEvent;
import org.gcube.portlets.user.messages.client.event.GridMessageSelectedEvent;
import org.gcube.portlets.user.messages.client.event.GridMessageUnSelectedEvent;
import org.gcube.portlets.user.messages.client.event.LoadMessagesEvent;
import org.gcube.portlets.user.messages.client.event.MarkMessageEvent;
import org.gcube.portlets.user.messages.client.event.OpenMessageEvent;
import org.gcube.portlets.user.messages.client.event.PreviewMessageEvent;
import org.gcube.portlets.user.messages.client.event.SaveAttachmentsEvent;
import org.gcube.portlets.user.messages.client.event.SendMessageEvent;
import org.gcube.portlets.user.messages.client.interfaces.EventsTypeEnum;
import org.gcube.portlets.user.messages.client.interfaces.GuiEventInterface;
import org.gcube.portlets.user.messages.client.interfaces.SubscriberInterface;
import org.gcube.portlets.user.messages.client.rpc.MessagesService;
import org.gcube.portlets.user.messages.client.rpc.MessagesServiceAsync;
import org.gcube.portlets.user.messages.client.view.GxtBorderLayoutMainPanel;
import org.gcube.portlets.user.messages.client.view.message.GxtGridMessagesFilterPanel;
import org.gcube.portlets.user.messages.shared.FileModel;
import org.gcube.portlets.user.messages.shared.MessageModel;

public class MessagesApplicationController {
    private static final HandlerManager eventBus = new HandlerManager(null);
    private MessagesMainPanel mainPanel;
    private HashMap<EventsTypeEnum, ArrayList<SubscriberInterface>> subscribers = new HashMap();
    private MessagesApplicationSubscriber messagesSubscriber;
    public static final MessagesServiceAsync rpcMessagesManagementService = (MessagesServiceAsync)GWT.create(MessagesService.class);
    protected static final int DELAY = 10000;

    public MessagesApplicationController() {
        this.bind();
    }

    public static HandlerManager getEventBus() {
        return eventBus;
    }

    public GxtGridMessagesFilterPanel getMessagesPanelContainer() {
        return this.mainPanel.getMessagesPanelContainer();
    }

    private void bind() {
        eventBus.addHandler(GetAllNewMessagesEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(GridMessageSelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(GridMessageUnSelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(MarkMessageEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(DeleteMessageEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(FileDownloadEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SaveAttachmentsEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(PreviewMessageEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(OpenMessageEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(LoadMessagesEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SendMessageEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void notifySubscriber(GuiEventInterface event) {
        if (this.subscribers.containsKey(event.getKey())) {
            for (SubscriberInterface sub : (ArrayList)this.subscribers.get(event.getKey())) {
                PreviewMessageEvent messageEvent;
                if (event instanceof LoadMessagesEvent) {
                    LoadMessagesEvent loadMessagesEvent = (LoadMessagesEvent)event;
                    if (loadMessagesEvent.getTypeMessages().equals("Sent")) {
                        sub.loadSentMessages();
                        continue;
                    }
                    sub.loadReceivedMessages();
                    continue;
                }
                if (event instanceof DeleteMessageEvent) {
                    DeleteMessageEvent deleteMessage = (DeleteMessageEvent)event;
                    sub.deleteMessage(deleteMessage.getMessageTarget().getId());
                    continue;
                }
                if (event instanceof MarkMessageEvent) {
                    MarkMessageEvent mark = (MarkMessageEvent)event;
                    sub.markAsReadMessage(mark.getMessageTarget().getId(), mark.getBoolMark());
                    continue;
                }
                if (event instanceof PreviewMessageEvent) {
                    messageEvent = (PreviewMessageEvent)event;
                    if (messageEvent.getMessageType().equals("Sent")) {
                        sub.updatePrevieMessage(messageEvent.getMessage());
                        continue;
                    }
                    sub.updatePrevieMessage(messageEvent.getMessage());
                    continue;
                }
                if (event instanceof SendMessageEvent) {
                    messageEvent = (SendMessageEvent)event;
                    HashMap<String, String> hashFiles = new HashMap<String, String>();
                    if (messageEvent.getListFileModelSelected() != null) {
                        for (FileModel fileModel : messageEvent.getListFileModelSelected()) {
                            hashFiles.put(fileModel.getIdentifier(), fileModel.getName());
                        }
                    }
                    sub.createNewMessage(hashFiles);
                    continue;
                }
                if (!(event instanceof OpenMessageEvent)) continue;
                messageEvent = (OpenMessageEvent)event;
                MessageModel message = messageEvent.getMessage();
                if (messageEvent.getOpenType().equals((Object)OpenMessageEvent.OpenType.FORWARD)) {
                    HashMap<String, String> hashAttachs = new HashMap<String, String>();
                    if (message.getListAttachments() != null) {
                        for (FileModel fileModel : message.getListAttachments()) {
                            hashAttachs.put(fileModel.getIdentifier(), fileModel.getName());
                        }
                    }
                    sub.forwardMessage(message.getFromLogin(), message.getSubject(), message.getListContactsToString(), message.getDate(), hashAttachs, message.getTextMessage());
                    continue;
                }
                if (messageEvent.getOpenType().equals((Object)OpenMessageEvent.OpenType.REPLY)) {
                    sub.replyMessage(message.getFromLogin(), message.getSubject(), new ArrayList(), message.getDate(), message.getTextMessage());
                    continue;
                }
                if (!messageEvent.getOpenType().equals((Object)OpenMessageEvent.OpenType.REPLYALL)) continue;
                sub.replyMessage(message.getFromLogin(), message.getSubject(), message.getListContactsToString(), message.getDate(), message.getTextMessage());
            }
        }
    }

    public void go(HasWidgets rootPanel) {
        this.mainPanel = new MessagesMainPanel();
        rootPanel.add((Widget)this.mainPanel.getBorderLayoutContainer());
        this.initApplication();
    }

    public GxtBorderLayoutMainPanel getMainPanel() {
        return this.mainPanel.getBorderLayoutContainer();
    }

    private void initApplication() {
        this.messagesSubscriber = new MessagesApplicationSubscriber(this);
        this.mainPanel.getMessagesPanel().setSelect("Received");
    }

    public void subscribe(SubscriberInterface subscriber, EventsTypeEnum[] keys) {
        EventsTypeEnum[] eventsTypeEnumArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            EventsTypeEnum m = eventsTypeEnumArray[n2];
            this.subscribe(subscriber, m);
            ++n2;
        }
    }

    public void subscribe(SubscriberInterface subscriber, EventsTypeEnum key) {
        if (this.subscribers.containsKey(key)) {
            ((ArrayList)this.subscribers.get(key)).add(subscriber);
        } else {
            ArrayList<SubscriberInterface> subs = new ArrayList<SubscriberInterface>();
            subs.add(subscriber);
            this.subscribers.put(key, subs);
        }
    }

    public void unsubscribe(SubscriberInterface subscriber, EventsTypeEnum key) {
        if (this.subscribers.containsKey(key)) {
            ((ArrayList)this.subscribers.get(key)).remove(subscriber);
        }
    }

    static /* synthetic */ MessagesMainPanel access$0(MessagesApplicationController messagesApplicationController) {
        return messagesApplicationController.mainPanel;
    }
}

