/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.lastupdatedfiles.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portlets.user.lastupdatedfiles.client.FileService;
import org.gcube.portlets.user.lastupdatedfiles.shared.FileItemsWrapper;
import org.gcube.portlets.user.lastupdatedfiles.shared.ImageType;
import org.gcube.portlets.user.lastupdatedfiles.shared.LufFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServiceImpl
extends RemoteServiceServlet
implements FileService {
    private static Logger _log = LoggerFactory.getLogger(FileServiceImpl.class);
    private static final int ITEMS_NO_TO_RETRIEVE = 6;
    public static final String TEST_USER = "test.user";
    public static final String LUF_CACHE_NAME = "LUF_CACHE";
    public static final String LAST_RETRIEVED_TIME = "LAST_RETRIEVED_TIME";

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devNext/NextNext");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = TEST_USER;
        return user;
    }

    public void setRead(String workspaceItemId) {
        String username = this.getASLSession().getUsername();
        if (username.compareTo(this.getDevelopmentUser()) != 0) {
            Workspace ws = null;
            try {
                ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(this.getASLSession().getUsername()).getWorkspace();
                ws.getItem(workspaceItemId).markAsRead(true);
                _log.debug(username + ": item read marked as true with id: " + workspaceItemId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public FileItemsWrapper getLastUpdateFiles() {
        FileItemsWrapper toReturn = null;
        ASLSession session = this.getASLSession();
        String currScope = session.getScope();
        toReturn = this.getFilesFromCache(session);
        if (toReturn != null) {
            return toReturn;
        }
        ArrayList<LufFileItem> fileItems = new ArrayList<LufFileItem>();
        Workspace ws = null;
        try {
            ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(this.getASLSession().getUsername()).getWorkspace();
            _log.info("Trying to get Group folder for scope=" + currScope);
            boolean isInfra = this.isInfrastructureScope();
            String folderName = "";
            String folderId = "";
            List items = null;
            if (this.isInfrastructureScope()) {
                WorkspaceFolder folder = (WorkspaceFolder)ws.getItemByPath("/Workspace/MySpecialFolders/");
                folderId = folder.getId();
                items = folder.getLastItems(6);
            } else {
                WorkspaceSharedFolder sharedFolder = ws.getVREFolderByScope(currScope);
                folderName = sharedFolder.getDisplayName();
                folderId = sharedFolder.getId();
                items = sharedFolder.getLastItems(6);
            }
            for (WorkspaceItem item : items) {
                String[] splits = item.getName().split("\\.");
                String extension = "";
                if (splits.length > 0) {
                    extension = splits[splits.length - 1];
                }
                fileItems.add(new LufFileItem(item.getId(), item.getName(), item.getOwner().getPortalLogin(), "", item.getLastModificationTime().getTime(), this.getIconImageType(extension), item.getPublicLink(false)));
            }
            toReturn = new FileItemsWrapper(folderName, folderId, fileItems, isInfra);
            this.storeFilesInCache(session, toReturn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private FileItemsWrapper getFilesFromCache(ASLSession session) {
        Long now = new Date().getTime();
        Long previous = (Long)session.getAttribute(LAST_RETRIEVED_TIME);
        if (previous == null) {
            return null;
        }
        if (now > previous + 60000L) {
            _log.debug("more than 60 secs have passed");
            return null;
        }
        _log.debug("less than 60 secs, getting from cache");
        FileItemsWrapper toReturn = (FileItemsWrapper)session.getAttribute(LUF_CACHE_NAME);
        return toReturn;
    }

    private void storeFilesInCache(ASLSession session, FileItemsWrapper wrapper) {
        session.setAttribute(LUF_CACHE_NAME, (Object)wrapper);
        session.setAttribute(LAST_RETRIEVED_TIME, (Object)new Date().getTime());
    }

    private ImageType getIconImageType(String extension) {
        if (extension == null || extension.compareTo("") == 0) {
            return ImageType.NONE;
        }
        switch (extension) {
            case "doc": 
            case "docx": 
            case "rtf": {
                return ImageType.DOC;
            }
            case "xls": 
            case "xlsx": {
                return ImageType.XLS;
            }
            case "ppt": 
            case "pptx": {
                return ImageType.PPT;
            }
            case "pdf": {
                return ImageType.PDF;
            }
            case "jpg": 
            case "jpeg": 
            case "gif": 
            case "bmp": 
            case "png": 
            case "tif": 
            case "tiff": {
                return ImageType.IMAGE;
            }
            case "avi": 
            case "mp4": 
            case "mpeg": {
                return ImageType.MOVIE;
            }
            case "html": 
            case "htm": 
            case "jsp": {
                return ImageType.HTML;
            }
            case "rar": {
                return ImageType.RAR;
            }
            case "zip": 
            case "tar": 
            case "tar.gz": {
                return ImageType.ZIP;
            }
        }
        return ImageType.NONE;
    }

    private boolean isInfrastructureScope() {
        boolean toReturn = false;
        try {
            ScopeBean scope = new ScopeBean(this.getASLSession().getScope());
            toReturn = scope.is(ScopeBean.Type.INFRASTRUCTURE);
            return toReturn;
        }
        catch (NullPointerException e) {
            _log.error("NullPointerException in isInfrastructureScope returning false");
            return false;
        }
    }
}

