/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.lastupdatedfiles.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.portlets.user.lastupdatedfiles.client.FileService;
import org.gcube.portlets.user.lastupdatedfiles.shared.FileItemsWrapper;
import org.gcube.portlets.user.lastupdatedfiles.shared.ImageType;
import org.gcube.portlets.user.lastupdatedfiles.shared.LufFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServiceImpl
extends RemoteServiceServlet
implements FileService {
    private static Logger _log = LoggerFactory.getLogger(FileServiceImpl.class);
    public static final String TEST_USER = "test.user";

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devNext/NextNext");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = TEST_USER;
        user = "massimiliano.assante";
        return user;
    }

    public FileItemsWrapper getLastUpdateFiles() {
        FileItemsWrapper toReturn = null;
        String currScope = this.getASLSession().getScope();
        ArrayList<LufFileItem> fileItems = new ArrayList<LufFileItem>();
        WorkspaceSharedFolder sharedFolder = null;
        Workspace ws = null;
        try {
            ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(this.getASLSession().getUsername()).getWorkspace();
            _log.info("Trying to get Group folder for scope=" + currScope);
            sharedFolder = ws.getVREFolderByScope(currScope);
            System.out.println(sharedFolder.getName());
            List items = sharedFolder.getLastItems(5);
            for (WorkspaceItem item : items) {
                String[] splits = item.getName().split("\\.");
                String extension = "";
                if (splits.length > 0) {
                    extension = splits[splits.length - 1];
                }
                fileItems.add(new LufFileItem(item.getName(), item.getOwner().getPortalLogin(), "", item.getLastModificationTime().getTime(), this.getIconImageType(extension), item.getPublicLink(false)));
            }
            toReturn = new FileItemsWrapper(sharedFolder.getDisplayName(), sharedFolder.getId(), fileItems);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private ImageType getIconImageType(String extension) {
        if (extension == null || extension.compareTo("") == 0) {
            return ImageType.NONE;
        }
        switch (extension) {
            case "doc": 
            case "docx": 
            case "rtf": {
                return ImageType.DOC;
            }
            case "xls": 
            case "xlsx": {
                return ImageType.XLS;
            }
            case "ppt": 
            case "pptx": {
                return ImageType.PPT;
            }
            case "pdf": {
                return ImageType.PDF;
            }
            case "jpg": 
            case "jpeg": 
            case "gif": 
            case "bmp": 
            case "png": 
            case "tif": 
            case "tiff": {
                return ImageType.IMAGE;
            }
            case "avi": 
            case "mp4": 
            case "mpeg": {
                return ImageType.MOVIE;
            }
            case "html": 
            case "htm": 
            case "jsp": {
                return ImageType.HTML;
            }
            case "rar": {
                return ImageType.RAR;
            }
            case "zip": 
            case "tar": 
            case "tar.gz": {
                return ImageType.ZIP;
            }
        }
        return ImageType.NONE;
    }
}

