package org.gcube.portlets.user.lastupdatedfiles.client.panel.ui;

import org.gcube.portlets.user.lastupdatedfiles.client.bundle.IconImages;
import org.gcube.portlets.user.lastupdatedfiles.shared.ImageType;
import org.gcube.portlets.user.lastupdatedfiles.shared.LufFileItem;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.DateTimeFormat.PredefinedFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
/**
 * 
 * @author massi
 *
 */
/**
 * 
 * @author massi
 *
 */
public class FileItem extends Composite {

	private static FileItemUiBinder uiBinder = GWT
			.create(FileItemUiBinder.class);

	interface FileItemUiBinder extends UiBinder<Widget, FileItem> {
	}
//	@UiField Image avatarImage;
	@UiField Image iconImage;
	@UiField HTML fileItem;
	
	private IconImages images = IconImages.INSTANCE;
	
	public FileItem(LufFileItem toDisplay) {
		initWidget(uiBinder.createAndBindUi(this));
		fileItem.setHTML("<a class=\"luflink\" href=\""+toDisplay.getFileDownLoadURL()+"\">"+toDisplay.getFilename()+"</a>");
		String theDate = DateTimeFormat.getFormat(PredefinedFormat.RFC_2822).format(toDisplay.getLastUpdated());
		fileItem.setTitle(toDisplay.getFilename() + " was last edited " + theDate + " by " + toDisplay.getOwnerUserName());
		iconImage.setUrl(getIconImage(toDisplay.getType()).getSafeUri());
		//avatarImage.setUrl(getIconImage(toDisplay.getType()).getSafeUri());
	}

	
	private ImageResource getIconImage(ImageType type) {
		switch (type) {
		case DOC:
			return images.docx();
		case XLS:
			return images.xls();
		case PPT:
			return images.pptx();
		case 
			PDF:
				return images.pdf();
		case IMAGE:
			return images.jpeg();
		case MOVIE:
			return images.avi();
		case HTML:
			return images.html();
		case RAR:
			return images.rar();
		case ZIP:
			return images.zip();
		default:
			return images.noType();
		}
	}
	
}
