package org.gcube.portlets.user.joinvre.shared;

import java.io.Serializable;
import java.util.List;

/**
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
@SuppressWarnings("serial")
public class VRE extends ResearchEnvironment implements Serializable, Comparable<VRE> {
	
	protected boolean uponRequest;
	protected long id;


	public VRE() {
		super();
	}

	/**
	 * @param id
	 * @param vreName
	 * @param description
	 * @param imageURL
	 * @param vomsGroupName
	 * @param friendlyURL
	 * @param categories
	 * @param userBelonging
	 * @param uponRequest
	 */
	public VRE(long id, String vreName, String description, String imageURL,
			String vomsGroupName, String friendlyURL, UserBelonging userBelonging,  boolean uponRequest) {
		super(vreName, description, imageURL, vomsGroupName, friendlyURL, userBelonging);	
		this.uponRequest = uponRequest;
		this.id = id;
	}
	
	public boolean isUponRequest() {
		return uponRequest;
	}
	public void setUponRequest(boolean uponRequest) {
		this.uponRequest = uponRequest;
	}
	
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	@Override
	public String toString() {
		return "VRE {" + getName() + ", "+ getFriendlyURL() + ", uponRequest=" + uponRequest+"}";
	}

	@Override
	public int compareTo(VRE vre) {
		return this.getName().compareTo(vre.getName());
	}
	
}
