/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinvre.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.client.panels.Relevance;
import org.gcube.portlets.user.joinvre.shared.UserBelonging;
import org.gcube.portlets.user.joinvre.shared.VRE;
import org.gcube.portlets.user.joinvre.shared.VRECategory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JoinServiceImpl
extends RemoteServiceServlet
implements JoinService {
    private static Log _log = LogFactoryUtil.getLog(JoinServiceImpl.class);
    private static final String REQUEST_BASED_GROUP = "Requestbasedgroup";
    private static final String RELEVANCE = "Relevance";
    public static final String ROOT_ORG = "rootorganization";

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn((Object)"USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace((Object)"Development Mode ON");
            return false;
        }
    }

    public ArrayList<VRE> getVREs() {
        ArrayList vres = new ArrayList();
        try {
            if (this.isWithinPortal()) {
                vres = this.getPortalOrganizationMappedToVRE();
            } else {
                ArrayList<VRECategory> devsecCategories = new ArrayList<VRECategory>();
                devsecCategories.add(new VRECategory(1L, "Development"));
                vres.add(new VRE(0L, "BiodiversityLab", "<h2>BiodiversityLab</h2>The BiodiversityLab is a VRE designed to provide a collection of applications that allow scholars to perform complete experiments about single individuals or groups of marine species. The VRE allows to: <ul> <li> inspect species maps;<li> produce a species distribution map by means of either an expert system (AquaMaps) or a machine learning model (e.g. Neural Networks);<li> analyse species observation trends;<li> inspect species occurrence data;<li> inspect species descriptions and characteristics;<li> perform analysis of climatic changes and of their effects on species distribution;<li> produce GIS maps for geo-spatial datasets;<li> discover Taxa names;<li> cluster occurrence data;<li> estimate similarities among habitats.</ul>", "", "", "/group/devsec", devsecCategories, 0, UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(0L, "Scalable Data Mining", "<h2>Scalable Data Mining</h2>The Scalable Data Mining  is a VRE designed to apply Data Mining techniques to biological data. The algorithms are executed in a distributed fashion on the e-Infrastructure nodes or on local multi-core machines. Scalability is thus meant as distributed data processing but even as services dynamically provided to the users. The system is scalable in the number of users and in the size of the data to process. Statistical data processing can be applied to perform Niche Modelling or Ecological Modelling experiments. Other applications can use general purpose techniques like Bayesian models. Time series of observations can be managed as well, in order to classify trends, catch anomaly patterns and perform simulations. The idea under the distributed computation for data mining techniques is to overcome common limitations that can happen when using statistical algorithms: single individuals or groups of marine species. The VRE allows to: <ul> <li> inspect species maps;<li> produce a species distribution map by means of either an expert system (AquaMaps) or a machine learning model (e.g. Neural Networks);<li> analyse species observation trends;<li> inspect species occurrence data;<li> inspect species descriptions and characteristics;<li> perform analysis of climatic changes and of their effects on species distribution;<li> produce GIS maps for geo-spatial datasets;<li> discover Taxa names;<li> cluster occurrence data;<li> estimate similarities among habitats.</ul>", "", "", "/group/devsec", devsecCategories, 0, UserBelonging.NOT_BELONGING, false));
                ArrayList<VRECategory> devVRECategories = new ArrayList<VRECategory>(devsecCategories);
                devVRECategories.add(new VRECategory(2L, "Sailing"));
                vres.add(new VRE(1L, "devVRE", "devVRE VRE description", "", "", "/group/devVRE", devVRECategories, 1, UserBelonging.NOT_BELONGING, false));
                ArrayList<VRECategory> devmodeategories = new ArrayList<VRECategory>(devsecCategories);
                devmodeategories.add(new VRECategory(3L, "Climbing"));
                vres.add(new VRE(2L, "devmode", "devmode VRE description", "", "", "/group/devmode", devmodeategories, 2, UserBelonging.NOT_BELONGING, true));
                vres.add(new VRE(3L, "devsec2", "devsec VRE description", "", "", "/group/devsec", devsecCategories, 0, UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(4L, "devsec3", "devsec VRE description", "", "", "/group/devsec", devsecCategories, 0, UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(5L, "devsec4", "devsec VRE description", "", "", "/group/devsec", devsecCategories, 1, UserBelonging.NOT_BELONGING, false));
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error getting VREs", (Throwable)e);
        }
        Collections.sort(vres, new /* Unavailable Anonymous Inner Class!! */);
        return vres;
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String protocol = request.isSecure() ? "https://" : "http://";
        String port = request.getServerPort() == 80 ? "" : String.format(":%d", request.getServerPort());
        String portalBasicUrl = String.format("%s%s%s", protocol, request.getServerName(), port);
        _log.debug((Object)String.format("getPortalBasicUrl : %s", portalBasicUrl));
        return portalBasicUrl;
    }

    public boolean requireAccessGrant(Organization organization) throws PortalException, SystemException {
        block3: {
            try {
                long companyId = OrganizationsUtil.getCompany().getCompanyId();
                _log.trace((Object)"Setting Thread Permission");
                User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)ScopeHelper.getAdministratorUsername());
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)false);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                _log.trace((Object)"Setting Permission ok!");
                if (organization.getExpandoBridge().getAttribute("Requestbasedgroup") != null && !organization.getExpandoBridge().getAttribute("Requestbasedgroup").equals("")) break block3;
                _log.trace((Object)String.format("Attribute %s not initialized. In this case by default Access Grant is permitted", "Requestbasedgroup"));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        String attributeValue = (String)((Object)organization.getExpandoBridge().getAttribute("Requestbasedgroup"));
        return attributeValue.compareTo("true") == 0;
    }

    public int getRelevance(Organization organization) {
        block4: {
            try {
                long companyId = OrganizationsUtil.getCompany().getCompanyId();
                _log.trace((Object)"Setting Thread Permission");
                User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)ScopeHelper.getAdministratorUsername());
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)false);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                _log.trace((Object)"Setting Permission ok!");
                if (organization.getExpandoBridge().getAttribute("Relevance") != null && !organization.getExpandoBridge().getAttribute("Relevance").equals("")) break block4;
                _log.trace((Object)String.format("Attribute %s not initialized. In this case by default Access Grant is permitted", "Relevance"));
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        }
        Integer relevanceValue = (Integer)organization.getExpandoBridge().getAttribute("Relevance");
        int relevance = relevanceValue;
        int maxAcceptableValue = Relevance.values().length - 1;
        if (relevance > maxAcceptableValue) {
            relevance = maxAcceptableValue;
        }
        return relevance;
    }

    public List<VRECategory> getCategory(Organization organization) throws SystemException {
        ArrayList<VRECategory> categories = new ArrayList<VRECategory>();
        long organizationPK = organization.getPrimaryKey();
        List categoryList = AssetCategoryLocalServiceUtil.getCategories((String)Organization.class.getName(), (long)organizationPK);
        for (AssetCategory assetCategory : categoryList) {
            categories.add(new VRECategory(assetCategory.getCategoryId(), assetCategory.getName()));
        }
        return categories;
    }

    public ArrayList<VRE> getPortalOrganizationMappedToVRE() throws SystemException, PortalException {
        ArrayList<VRE> vres = new ArrayList<VRE>();
        List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        Organization rootOrganization = null;
        for (Organization organization : organizations) {
            if (!organization.getName().equals(JoinServiceImpl.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        try {
            _log.info((Object)("root: " + rootOrganization.getName()));
        }
        catch (NullPointerException e) {
            _log.error((Object)"Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
            return new ArrayList<VRE>();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
        String imagePath = "/image";
        if (themeDisplay != null) {
            imagePath = themeDisplay.getPathImage();
        }
        for (Organization vOrg : rootOrganization.getSuborganizations()) {
            for (Organization vreOrganization : vOrg.getSuborganizations()) {
                long vreID = vreOrganization.getOrganizationId();
                String vreName = vreOrganization.getName();
                String vreDescription = vreOrganization.getComments() != null ? vreOrganization.getComments() : "";
                long logoId = vreOrganization.getLogoId();
                String vreLogoURL = String.format("%s/organization_logo?img_id=%s&t=%s", imagePath, logoId, ImageServletTokenUtil.getToken((long)logoId));
                String groupName = String.format("/%s/%s/%s", vOrg.getParentOrganization().getName(), vOrg.getName(), vreName);
                Group vreGroup = vreOrganization.getGroup();
                String friendlyURL = String.valueOf(vreGroup.getPathFriendlyURL(true, themeDisplay)) + vreGroup.getFriendlyURL();
                friendlyURL = String.format("%s%s", this.getPortalBasicUrl(), friendlyURL);
                boolean requireAccessGrant = this.requireAccessGrant(vreOrganization);
                List categories = this.getCategory(vreOrganization);
                _log.debug((Object)String.format("VRE preferences : %s", vreOrganization.getPreferences()));
                int relevance = this.getRelevance(vreOrganization);
                vres.add(new VRE(vreID, vreName, vreDescription, vreLogoURL, groupName, friendlyURL, categories, relevance, UserBelonging.NOT_BELONGING, requireAccessGrant));
            }
        }
        return vres;
    }

    protected static String getRootOrganizationName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = String.valueOf(OrganizationsUtil.getTomcatFolder()) + "conf/gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("rootorganization");
        }
        catch (IOException e) {
            toReturn = "gcube";
            _log.error((Object)("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default VO Name " + toReturn));
            return toReturn;
        }
        _log.debug((Object)("Returning Root VO Name: " + toReturn));
        return toReturn;
    }

    public Boolean joinVRE(Long vreID) {
        return new Boolean(true);
    }
}

