/**
 * 
 */
package org.gcube.portlets.user.joinvre.shared;

import java.io.Serializable;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
@SuppressWarnings("serial")
public class VRECategory implements Serializable, Comparable<VRECategory> {

	protected long categoryID;
	protected String name;
	
	public VRECategory() {
		super();
	}

	/**
	 * @param categoryID
	 * @param name
	 */
	public VRECategory(long categoryID, String name) {
		super();
		this.categoryID = categoryID;
		this.name = name;
	}
	
	/**
	 * @return the categoryID
	 */
	public long getCategoryID() {
		return categoryID;
	}
	/**
	 * @param categoryID the categoryID to set
	 */
	public void setCategoryID(long categoryID) {
		this.categoryID = categoryID;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/** {@inheritDoc} */
	@Override
	public int compareTo(VRECategory vreCategory) {
		return name.compareTo(vreCategory.name);
	}
}
