package org.gcube.portlets.user.joinvre.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.client.panels.Relevance;
import org.gcube.portlets.user.joinvre.shared.UserBelonging;
import org.gcube.portlets.user.joinvre.shared.VRE;
import org.gcube.portlets.user.joinvre.shared.VRECategory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;

/**
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
@SuppressWarnings("serial")
public class JoinServiceImpl extends RemoteServiceServlet implements JoinService {
	
	private static Log _log = LogFactoryUtil.getLog(JoinServiceImpl.class);

	/**
	 * the current ASLSession
	 * @return the session
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		if (user == null) {
			_log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
			user = getDevelopmentUser();
			SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube");
		}		
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	
	/**
	 * when packaging test will fail if the user is not set to test.user
	 * @return .
	 */
	public String getDevelopmentUser() {
		String user = "test.user";
		return user;
	}
	
	/**
	 * 
	 * @return true if you're running into the portal, false if in development
	 */
	private boolean isWithinPortal() {
		try {
			UserLocalServiceUtil.getService();
			return true;
		} catch (com.liferay.portal.kernel.bean.BeanLocatorException ex) {			
			_log.trace("Development Mode ON");
			return false;
		}			
	}
	/**
	 * 
	 * @param session the Asl Session
	 * @param withinPortal true when is on Liferay portal
	 * @return the users belonging to the current organization (scope)
	 */
	@Override
	public ArrayList<VRE> getVREs() {
		ArrayList<VRE> vres = new ArrayList<VRE>();

		try {
			if (isWithinPortal()) {
				vres = getPortalOrganizationMappedToVRE();
			} else {
				List<VRECategory> devsecCategories = new ArrayList<VRECategory>();
				devsecCategories.add(new VRECategory(1, "Development"));
				vres.add(new VRE(0, "BiodiversityLab", ""
						+ "<h2>BiodiversityLab</h2>"
						+ "The BiodiversityLab is a VRE designed to provide a collection of applications that allow scholars to perform complete experiments about "
						+ "single individuals or groups of marine species. The VRE allows to: <ul> <li> inspect species maps;<li> produce a species distribution map by means of either an expert system (AquaMaps) or a machine learning model (e.g. Neural Networks);"
						+ "<li> analyse species observation trends;"
						+ "<li> inspect species occurrence data;"
						+ "<li> inspect species descriptions and characteristics;"
						+ "<li> perform analysis of climatic changes and of their effects on species distribution;"
						+ "<li> produce GIS maps for geo-spatial datasets;"
						+ "<li> discover Taxa names;"
						+ "<li> cluster occurrence data;"
						+ "<li> estimate similarities among habitats."
						+ "</ul>"
						+ "", "", "", "/group/devsec", devsecCategories, 0,UserBelonging.NOT_BELONGING, false));
				vres.add(new VRE(0, "Scalable Data Mining", ""
						+ "<h2>Scalable Data Mining</h2>"
						+ "The Scalable Data Mining  is a VRE designed to apply Data Mining techniques to biological data. The algorithms are executed in a distributed fashion on the e-Infrastructure nodes or on local multi-core machines. Scalability is thus meant as distributed data processing but even as services dynamically provided to the users. The system is scalable in the number of users and in the size of the data to process. Statistical data processing can be applied to perform Niche Modelling or Ecological Modelling experiments. Other applications can use general purpose techniques like Bayesian models. Time series of observations can be managed as well, in order to classify trends, catch anomaly patterns and perform simulations. The idea under the distributed computation for data mining techniques is to overcome common limitations that can happen when using statistical algorithms: "
						+ "single individuals or groups of marine species. The VRE allows to: <ul> <li> inspect species maps;<li> produce a species distribution map by means of either an expert system (AquaMaps) or a machine learning model (e.g. Neural Networks);"
						+ "<li> analyse species observation trends;"
						+ "<li> inspect species occurrence data;"
						+ "<li> inspect species descriptions and characteristics;"
						+ "<li> perform analysis of climatic changes and of their effects on species distribution;"
						+ "<li> produce GIS maps for geo-spatial datasets;"
						+ "<li> discover Taxa names;"
						+ "<li> cluster occurrence data;"
						+ "<li> estimate similarities among habitats."
						+ "</ul>"
						+ "", "", "", "/group/devsec", devsecCategories, 0,UserBelonging.NOT_BELONGING, false));
				List<VRECategory> devVRECategories = new ArrayList<VRECategory>(devsecCategories);
				devVRECategories.add(new VRECategory(2, "Sailing"));
				vres.add(new VRE(1, "devVRE", "devVRE VRE description", "", "", "/group/devVRE", devVRECategories, 1, UserBelonging.NOT_BELONGING, false));
				List<VRECategory> devmodeategories = new ArrayList<VRECategory>(devsecCategories);
				devmodeategories.add(new VRECategory(3, "Climbing"));
				vres.add(new VRE(2, "devmode", "devmode VRE description", "", "", "/group/devmode", devmodeategories, 2, UserBelonging.NOT_BELONGING, true));
				vres.add(new VRE(3, "devsec2", "devsec VRE description", "", "", "/group/devsec", devsecCategories, 0, UserBelonging.NOT_BELONGING, false));
				vres.add(new VRE(4, "devsec3", "devsec VRE description", "", "", "/group/devsec", devsecCategories, 0, UserBelonging.NOT_BELONGING, false));
				vres.add(new VRE(5, "devsec4", "devsec VRE description", "", "", "/group/devsec", devsecCategories, 1, UserBelonging.NOT_BELONGING, false));
			}
		} catch (Exception e) {
			_log.error("Error getting VREs", e);
		}
		
		// Ordering VREs by Name
		Collections.sort(vres, new Comparator<VRE>(){
			@Override
			public int compare(VRE vre1, VRE vre2) {
				int relevanceDiff = vre1.getRelevance() - vre2.getRelevance();
				if (relevanceDiff != 0) {
			        return relevanceDiff;
				} else {
					return vre1.getName().compareTo(vre2.getName());
			    }
			}
		});
		return vres;
	}
	
	private String getPortalBasicUrl() {
		HttpServletRequest request = this.getThreadLocalRequest();
		String protocol = (request.isSecure()) ? "https://" : "http://" ;
		String port = (request.getServerPort() == 80) ? "" : String.format(":%d", request.getServerPort());
		String portalBasicUrl = String.format("%s%s%s", protocol, request.getServerName(), port);
		_log.debug(String.format("getPortalBasicUrl : %s",  portalBasicUrl));
		return portalBasicUrl;
	}
	
	private static final String REQUEST_BASED_GROUP = "Requestbasedgroup";
	
	public boolean requireAccessGrant(Organization organization) throws PortalException, SystemException {
		try {
			long companyId = OrganizationsUtil.getCompany().getCompanyId();
			_log.trace("Setting Thread Permission");
			User user = UserLocalServiceUtil.getUserByScreenName(companyId, ScopeHelper.getAdministratorUsername());
			PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user, false);
			PermissionThreadLocal.setPermissionChecker(permissionChecker);
			_log.trace("Setting Permission ok!");
			
			if (organization.getExpandoBridge().getAttribute(REQUEST_BASED_GROUP) == null || organization.getExpandoBridge().getAttribute(REQUEST_BASED_GROUP).equals("")) {
				_log.trace(String.format("Attribute %s not initialized. In this case by default Access Grant is permitted", REQUEST_BASED_GROUP));
				return true;
			} else {
				String attributeValue = (String) organization.getExpandoBridge().getAttribute(REQUEST_BASED_GROUP);
				return (attributeValue.compareTo("true") == 0);
			}
		} catch (Exception e) {
			return false;
		}
	}
	
	private static final String RELEVANCE = "Relevance";
	
	public int getRelevance(Organization organization){
		try {
			long companyId = OrganizationsUtil.getCompany().getCompanyId();
			_log.trace("Setting Thread Permission");
			User user = UserLocalServiceUtil.getUserByScreenName(companyId, ScopeHelper.getAdministratorUsername());
			PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user, false);
			PermissionThreadLocal.setPermissionChecker(permissionChecker);
			_log.trace("Setting Permission ok!");
			
			if (organization.getExpandoBridge().getAttribute(RELEVANCE) == null ||  organization.getExpandoBridge().getAttribute(RELEVANCE).equals("")) {
				_log.trace(String.format("Attribute %s not initialized. In this case by default Access Grant is permitted", RELEVANCE));
				return 0;
			} else {
				Integer relevanceValue = (Integer) organization.getExpandoBridge().getAttribute(RELEVANCE);
				int relevance = relevanceValue.intValue();
				int maxAcceptableValue = Relevance.values().length - 1;
				if(relevance > maxAcceptableValue){
					relevance = maxAcceptableValue;
				}
				return relevance;
			}
		} catch (Exception e) {
			return 0;
		}
	}
	
	public List<VRECategory> getCategory(Organization organization) throws SystemException{
		List<VRECategory> categories = new ArrayList<VRECategory>();
		long organizationPK = organization.getPrimaryKey();
		List<AssetCategory> categoryList = AssetCategoryLocalServiceUtil.getCategories(Organization.class.getName(), organizationPK);
		for(AssetCategory assetCategory : categoryList){
			categories.add(new VRECategory(assetCategory.getCategoryId(), assetCategory.getName()));
		}
		return categories;
	}
	
	public ArrayList<VRE> getPortalOrganizationMappedToVRE() throws SystemException, PortalException {
		
		ArrayList<VRE> vres = new ArrayList<VRE>();
		
		List<Organization> organizations = OrganizationLocalServiceUtil.getOrganizations(0, OrganizationLocalServiceUtil.getOrganizationsCount());
		Organization rootOrganization = null;
		for (Organization organization : organizations) {
			if (organization.getName().equals(getRootOrganizationName())) {
				rootOrganization = organization;
				break;
			}
		}
		
		try {
			_log.info("root: " + rootOrganization.getName() );
		} catch (NullPointerException e) {
			_log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
			return new ArrayList<VRE>();
		}
		
		ThemeDisplay themeDisplay = (ThemeDisplay) this.getThreadLocalRequest().getSession().getAttribute(WebKeys.THEME_DISPLAY);
		String imagePath = "/image";
		if(themeDisplay!=null){
			imagePath = themeDisplay.getPathImage();
		} /*If themeDisplay is null the user is not logged in. Needs to find a way to get it */
		
		//for each root sub organizations (VO)
		for (Organization vOrg : rootOrganization.getSuborganizations()) {
			for (Organization vreOrganization : vOrg.getSuborganizations()) {
				long vreID =  vreOrganization.getOrganizationId();
				String vreName = vreOrganization.getName();
				String vreDescription = (vreOrganization.getComments()!=null) ? vreOrganization.getComments() : "";
				
				long logoId = vreOrganization.getLogoId();
				String vreLogoURL = String.format("%s/organization_logo?img_id=%s&t=%s", imagePath, logoId, ImageServletTokenUtil.getToken(logoId));
				
				String groupName = String.format("/%s/%s/%s", vOrg.getParentOrganization().getName(), vOrg.getName(), vreName);
				Group vreGroup = vreOrganization.getGroup();
				String friendlyURL = vreGroup.getPathFriendlyURL(true, themeDisplay) + vreGroup.getFriendlyURL();
				friendlyURL = String.format("%s%s", getPortalBasicUrl(), friendlyURL);
				
				boolean requireAccessGrant = requireAccessGrant(vreOrganization);
				
				List<VRECategory> categories = getCategory(vreOrganization);
				_log.debug(String.format("VRE preferences : %s", vreOrganization.getPreferences()));
				
				int relevance = getRelevance(vreOrganization);
				
				vres.add(new VRE(vreID,vreName, vreDescription, vreLogoURL, groupName,friendlyURL, categories, relevance, UserBelonging.NOT_BELONGING, requireAccessGrant));
			}
		}
		
		return vres;
	}
	
	public static final String ROOT_ORG = "rootorganization";
	
	/**
	 * read the root VO name from a property file and retuns it
	 */
	protected static String getRootOrganizationName() {
		//get the portles to look for from the property file
		Properties props = new Properties();
		String toReturn = "";

		try {
			String propertyfile = OrganizationsUtil.getTomcatFolder()+"conf/gcube-data.properties";			
			File propsFile = new File(propertyfile);
			FileInputStream fis = new FileInputStream(propsFile);
			props.load( fis);
			toReturn = props.getProperty(ROOT_ORG);
		}
		//catch exception in case properties file does not exist
		catch(IOException e) {
			toReturn = "gcube";
			_log.error("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default VO Name " + toReturn);
			return toReturn;
		}
		_log.debug("Returning Root VO Name: " + toReturn );
		return toReturn;
	}

	@Override
	public Boolean joinVRE(Long vreID) {
		// Here for future improvement
		return new Boolean(true);
	}
}
