package org.gcube.portlets.user.joinvre.client.panels;

import java.util.ArrayList;

import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.client.JoinServiceAsync;
import org.gcube.portlets.user.joinvre.client.ui.DisplayVRE;
import org.gcube.portlets.user.joinvre.shared.VRE;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class JoinVREPanel extends Composite {
	/**
	 * Create a remote service proxy to talk to the server-side Greeting service.
	 */
	private final JoinServiceAsync joinService = GWT.create(JoinService.class);
	public static final String loading = GWT.getModuleBaseURL() + "../images/vre-loader.gif";
	
	private VerticalPanel mainPanel;
	
	public JoinVREPanel() {
		super();
		this.mainPanel = new VerticalPanel();
		showLoader();
		
		joinService.getVREs(new AsyncCallback<ArrayList<VRE>>() {

			@Override
			public void onSuccess(ArrayList<VRE> vres) {
				mainPanel.clear();
				mainPanel.setHorizontalAlignment(HasAlignment.ALIGN_LEFT);
				mainPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
				
				
				if (vres == null || vres.isEmpty()) {
					mainPanel.add(new HTML("<div class=\"frame\" style=\"font-size: 16px;\">Ops, something went wrong. Please <a href=\"javascript: location.reload();\">reload<a/> this page.</div>"));
				} else {
					
					int panelSize = vres.get(vres.size()-1).getRelevance();
					FlowPanel[] panels = new FlowPanel[panelSize];
					int last = -1;
					for (VRE vre : vres) {
						int relevance = vre.getRelevance();
						if(last < relevance){
							panels[relevance] = new FlowPanel();
							Label label = new Label(Relevance.values()[relevance].name().replace('_', ' '));
							label.addStyleName("relevance");
							if(relevance == 0){
								label.addStyleName("first");
							}
							panels[relevance].add(label);
							mainPanel.add(panels[relevance]);
							last = relevance;
						}
						panels[relevance].add(new DisplayVRE(vre));
					}
					
				}
				
			}

			@Override
			public void onFailure(Throwable caught) {
				mainPanel.add(new HTML("<div class=\"nofeed-message\">" +
						"Sorry, looks like something is broken with the server connection<br> " +
						"Please check your connection and try refresh this page.</div>"));

			}
			
		});
		initWidget(mainPanel);
	}


	private void showLoader() {
		mainPanel.clear();
		mainPanel.setWidth("100%");
		mainPanel.setHeight("300px");
		mainPanel.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
		mainPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		
		Image loadingImage = new Image(loading);
		mainPanel.add(loadingImage);
	}
	
}
