package org.gcube.portlets.user.invitefriends.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.invitefriends.client.InviteService;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class InviteServiceImpl extends RemoteServiceServlet implements InviteService {

	private final static Logger _log = LoggerFactory.getLogger(InviteServiceImpl.class);
	private final static String MAIL_SERVICE_HOST = "localhost";
	private final static String MAIL_SERVICE_PORT = "25";
	private static final String SENDER_EMAIL = "notificationSenderEmail";
	
	/**
	 * the current ASLSession
	 * @return the session
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		if (user == null) {
			_log.warn("USER IS NULL setting test.user");
			user = "test.user";
		}
		else {
			_log.info("LIFERAY PORTAL DETECTED user=" + user);
		}
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	/**
	 * 
	 */
	@Override
	public Boolean sendInviteEmail(String name, String lastName, String email) throws IllegalArgumentException {
		ASLSession aslSession = getASLSession();
		String vreName =  aslSession.getGroupName();
		String fromFullName = aslSession.getUserFullName(); 
	
		
		Properties props = System.getProperties();
		Session session = null;
		props.put("mail.smtp.host", MAIL_SERVICE_HOST);
		props.put("mail.smtp.port", MAIL_SERVICE_PORT);
		session = Session.getDefaultInstance(props);
		session.setDebug(true);

		try {
			MimeMessage message = new MimeMessage(session);
			message.setHeader("Content-Type", "text/plain; charset=UTF-8");
			// Set From: header field of the header.
			message.setFrom(new InternetAddress(getSenderEmail(), fromFullName));
			message.addRecipient(Message.RecipientType.TO, new InternetAddress(email));
			message.addRecipient(Message.RecipientType.CC, new InternetAddress(aslSession.getUserEmailAddress()));

			// Set Subject: header field
			message.setSubject("Join me on " + vreName);

			// Now set the actual message
			message.setText(getTextEmail(name, lastName, email, fromFullName, vreName));

			// Send message
			Transport.send(message);
			_log.debug("Sent message successfully to " + email );
		} catch (Exception mex) {
			mex.printStackTrace();
			_log.error("Sent message ERROR to " + email );
			return false;
		}
		return true;
	}
	

	private String getTextEmail(String name, String lastName, String email, String fromFullName, String vreName) {
		String portalUrl = null;
		String vreDescription  = null;
		long organizationId = getASLSession().getGroupId();
		try {
			portalUrl = PortalUtil.getPortalURL(OrganizationsUtil.getCompany().getVirtualHost(), PortalUtil.getPortalPort(), true);
			vreDescription = OrganizationLocalServiceUtil.getOrganization(organizationId).getComments();
		} catch (Exception e1) {
			e1.printStackTrace();
			_log.warn("While trying to send email for invitation to " + email);
			return null;
		} 
		
		StringBuilder body = new StringBuilder();
		
		body.append("Dear " + name)
		.append(",\n")
		.append(fromFullName).append(" has invited you to " + vreName + ", you can find a brief description below:")
		.append("\n").append(vreDescription)
		.append("\n\n")
		.append("To accept the invite just follow this link: " + portalUrl + "/group/data-e-infrastructure-gateway/join-new?orgid="+organizationId)
		.append("\n\n")
		.append("Please note: if you do not have an account yet, please sign up first: " + portalUrl + "/web/guest/home?p_p_id=58&_58_struts_action=%2Flogin%2Fcreate_account")
		.append("\n\n\n\n")
		.append("WARNING / LEGAL TEXT: This message is intended only for the use of the individual or entity to which it is addressed and may contain")
		.append("information which is privileged, confidential, proprietary, or exempt from disclosure under applicable law. "
				+ "If you are not the intended recipient or the person responsible for delivering the message to the intended recipient, "
				+ "you are strictly prohibited from disclosing, distributing, copying, or in any way using this message.")
				.append("If you have received this communication in error, please notify the <sender> and destroy and delete any copies you may have received.");

		return body.toString();

	}

	/**
	 * read the sender email for notifications name from a property file and returns it
	 */
	private static String getSenderEmail() {
		//get the portles to look for from the property file
		Properties props = new Properties();
		String toReturn = "";

		try {
			String propertyfile = OrganizationsUtil.getTomcatFolder()+"conf/gcube-data.properties";			
			File propsFile = new File(propertyfile);
			FileInputStream fis = new FileInputStream(propsFile);
			props.load( fis);
			toReturn = props.getProperty(SENDER_EMAIL);
		}
		//catch exception in case properties file does not exist
		catch(IOException e) {
			toReturn = "do-not-reply@d4science.org";
			_log.error("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default Email" + toReturn);
			return toReturn;
		}
		_log.debug("Returning SENDER_EMAIL: " + toReturn );
		return toReturn;
	}

	/**
	 * Convert html into simple text
	 * 
	 */
	protected static String convertHTML2Text(String html) {
		if (html == null) {
			return null;
		}
		String removedMarkup = html.replaceAll("&amp;", "&");
		removedMarkup = removedMarkup.replaceAll("&gt;", ">");
		removedMarkup = removedMarkup.replaceAll("&lt;", "<");
		String text = removedMarkup;
		try {
			Document document = Jsoup.parse(removedMarkup);
			Element body = document.body();
			text = buildStringFromNode(body).toString();
		}
		catch (Exception e) {
			_log.error("While converting HTML into text: " +e.getMessage());
			return removedMarkup;
		}
		return text;
	}
	
	private static StringBuffer buildStringFromNode(Node node) {
		StringBuffer buffer = new StringBuffer();

		if (node instanceof TextNode) {
			TextNode textNode = (TextNode) node;
			buffer.append(textNode.text().trim());
		}

		for (Node childNode : node.childNodes()) {
			buffer.append(buildStringFromNode(childNode));
		}

		if (node instanceof Element) {
			Element element = (Element) node;
			String tagName = element.tagName();
			if ("p".equals(tagName) || "br".equals(tagName)) {
				buffer.append("\n");
			}
		}

		return buffer;
	}
}
