/*******************************************************************************
 * Copyright 2011 Google Inc. All Rights Reserved.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.gcube.portlets.user.collectionsindexedwords.client;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class IndexedCollectionsVisualizer implements EntryPoint {
//	private Button button;
	public void onModuleLoad() {

		RootPanel rootPanel = RootPanel.get();
		
		IndexVisualisationPanel visualisation  = new IndexVisualisationPanel(1000,1000, "vis");
		
		rootPanel.add(visualisation);
		
	    Map <String,String> colls = new HashMap<String, String>();
	    colls.put("FishBase", "100");
	    colls.put("BioRisk", "140");
	    colls.put("Ecoscope", "200");
	    
	    Map <String,String> words = new HashMap<String, String>();
	    words.put("Σπάρος","200");
	    words.put("Κοκοβιός","210");
	    words.put("Αθερίνα","120");
	    words.put("Γαύρος","180");
	    words.put("Γατόψαρο","110");
	    words.put("Γύλος","140");
	    
	    //wordcloud with outer collections ring
//		visualisation.visualiseData(colls, words);
	    
	    //only wordcloud
	    visualisation.visualiseData(null, words);
		
		
	}
	
	
	
	
	
}
