/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.testdata;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.testdata.TestDataManagerUtil;
import org.gcube.portlets.user.homelibrary.testdata.data.TestData;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public abstract class TwinDataManager<T extends TestData, E, D> {
    protected Logger logger = Logger.getLogger(TwinDataManager.class);
    protected XStream xstream;
    protected Random random;
    protected List<T> data;

    public TwinDataManager(String dataListFile) {
        this.configureXStream();
        this.random = new Random();
        this.data = this.loadData(dataListFile);
    }

    protected abstract void configureXStream();

    protected List<T> loadData(String dataListFile) {
        String dataListPath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + dataListFile;
        this.logger.debug((Object)("Loading the data list from: " + dataListPath));
        InputStream dataList = TestDataFactory.class.getResourceAsStream(dataListPath);
        List data = (List)this.xstream.fromXML(dataList);
        this.logger.trace((Object)("Loaded " + data.size() + " test data."));
        return data;
    }

    protected abstract E createExternal(WorkspaceFolder var1, String var2, String var3, String var4, InputStream var5) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException;

    protected E fillExternal(WorkspaceFolder destinationFolder, T testData) throws InternalErrorException {
        InputStream dataStream = TestDataManagerUtil.getTestDataStream(testData);
        try {
            String name = WorkspaceUtil.getUniqueName((String)testData.getName(), (WorkspaceFolder)destinationFolder);
            return this.createExternal(destinationFolder, name, testData.getDescription(), testData.getMimeType(), dataStream);
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error((Object)"Error creating the external", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error((Object)"Error creating the external", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<E> fillExternals(WorkspaceFolder destinationFolder, int numberOfData) throws InternalErrorException {
        int counter = 0;
        LinkedList<E> externals = new LinkedList<E>();
        while (counter < numberOfData) {
            int dataIndex = counter % this.data.size();
            TestData image = (TestData)this.data.get(dataIndex);
            E external = this.fillExternal(destinationFolder, image);
            externals.add(external);
            ++counter;
        }
        return externals;
    }

    public List<E> fillAllExternals(WorkspaceFolder destinationFolder) throws InternalErrorException {
        LinkedList<E> externals = new LinkedList<E>();
        for (TestData image : this.data) {
            E external = this.fillExternal(destinationFolder, image);
            externals.add(external);
        }
        return externals;
    }

    protected abstract D createDocument(WorkspaceFolder var1, String var2, String var3, String var4, String var5, InputStream var6, Map<String, String> var7, Map<String, String> var8, String var9) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException;

    protected D fillDocument(WorkspaceFolder destinationFolder, T document) throws InternalErrorException {
        InputStream documentStream = TestDataManagerUtil.getTestDataStream(document);
        try {
            String name = WorkspaceUtil.getUniqueName((String)document.getName(), (WorkspaceFolder)destinationFolder);
            Map<String, String> metadata = TestDataManagerUtil.loadMetadatas(document.getMetadatas());
            return this.createDocument(destinationFolder, name, document.getDescription(), TestDataManagerUtil.getUID(), document.getMimeType(), documentStream, metadata, new LinkedHashMap<String, String>(), document.getCollectionName());
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error((Object)"Error creating the document", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error((Object)"Error creating the document", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<D> fillDocuments(WorkspaceFolder destinationFolder, int numberOfDocuments) throws InternalErrorException {
        int counter = 0;
        LinkedList<D> documents = new LinkedList<D>();
        while (counter < numberOfDocuments) {
            int imgIndex = counter % this.data.size();
            TestData testData = (TestData)this.data.get(imgIndex);
            D document = this.fillDocument(destinationFolder, testData);
            documents.add(document);
            ++counter;
        }
        return documents;
    }

    public List<D> fillAllDocuments(WorkspaceFolder destinationFolder) throws InternalErrorException {
        LinkedList<D> documents = new LinkedList<D>();
        for (TestData testData : this.data) {
            D document = this.fillDocument(destinationFolder, testData);
            documents.add(document);
        }
        return documents;
    }

    protected T getRandomDocumentData() {
        int dataIndex = this.random.nextInt(this.data.size());
        return (T)((TestData)this.data.get(dataIndex));
    }

    public InputStream getRandomInputStream() {
        T image = this.getRandomDocumentData();
        return TestDataManagerUtil.getTestDataStream(image);
    }

    public File getTMPRandomFile() throws InternalErrorException {
        try {
            File tmp = File.createTempFile("randomFile", "tmp");
            tmp.deleteOnExit();
            InputStream is = this.getRandomInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(tmp));
            return tmp;
        }
        catch (IOException e) {
            this.logger.error((Object)"Error creating tmp data", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }
}

