/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.unittest.workspace;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.unittest.workspace.WorkspaceFactory;
import org.gcube.portlets.user.homelibrary.util.config.easyconf.ComponentConfiguration;
import org.gcube.portlets.user.homelibrary.util.config.easyconf.ComponentProperties;
import org.gcube.portlets.user.homelibrary.util.config.easyconf.EasyConf;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractWorkspaceTest {
    protected static final String DEFAULT_PROPERTY_FILES = "unittest.properties";
    protected static List<Object[]> factories;
    protected WorkspaceFactory factory;
    protected Workspace ownerWorkspace;
    protected Map<String, Workspace> userWorkspaces = new HashMap<String, Workspace>();

    public AbstractWorkspaceTest(WorkspaceFactory factory) {
        this.factory = factory;
    }

    @Parameterized.Parameters
    public static List<Object[]> instances() {
        if (factories == null) {
            factories = new LinkedList<Object[]>();
            URL url = EasyConf.class.getResource(DEFAULT_PROPERTY_FILES);
            String name = url.toExternalForm();
            int pos = name.lastIndexOf(".properties");
            if (pos != -1) {
                name = name.substring(0, pos);
            }
            ComponentConfiguration componentConfiguration = EasyConf.getConfiguration((String)name);
            ComponentProperties properties = componentConfiguration.getProperties();
            try {
                Class[] classes;
                Class[] classArray = classes = properties.getClassArray("default-workspace-area-factories");
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class clazz = classArray[n2];
                    Object[] array = new Object[]{clazz.newInstance()};
                    factories.add(array);
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return factories;
    }

    @Before
    public void setupWorkspace() throws InternalErrorException {
        this.ownerWorkspace = this.factory.getWorkspace();
    }

    @Before
    public void setupListWorkspace() throws InternalErrorException {
        this.userWorkspaces = this.factory.getTestWorkspaces();
    }

    @After
    public void clean() throws InternalErrorException, HomeNotFoundException {
        this.factory.cleanWorkspace();
    }
}

