/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.config;

import java.io.File;
import java.net.URL;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.util.config.easyconf.ComponentConfiguration;
import org.gcube.portlets.user.homelibrary.util.config.easyconf.ComponentProperties;
import org.gcube.portlets.user.homelibrary.util.config.easyconf.EasyConf;

public class HomeLibraryConfiguration {
    public static final String HOME_LIBRARY_PERSISTENCE_DIR_VARIABLE_NAME = "HOME_LIBRARY_PERSISTENCE_DIR";
    protected static final String PERSISTENCE_FOLDER = "persistence-folder";
    private static final String HOME_MANAGER_FACTORY_IMPLEMENTATION = "home-manager-factory-implementation";
    protected static final String DEFAULT_PROPERTY_FILES = "/org/gcube/portlets/user/homelibrary/home/homelibrary.properties";
    protected static HomeLibraryConfiguration configuration;
    protected ComponentConfiguration componentConfiguration;
    protected ComponentProperties properties;
    protected Logger logger = Logger.getLogger(HomeLibraryConfiguration.class);

    public static HomeLibraryConfiguration getInstance() {
        if (configuration == null) {
            configuration = new HomeLibraryConfiguration();
        }
        return configuration;
    }

    protected HomeLibraryConfiguration() {
        URL url = EasyConf.class.getResource(DEFAULT_PROPERTY_FILES);
        String name = url.toExternalForm();
        int pos = name.lastIndexOf(".properties");
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        this.componentConfiguration = EasyConf.getConfiguration(name);
        this.properties = this.componentConfiguration.getProperties();
        this.properties.setThrowExceptionOnMissing(true);
    }

    public Class<?> getHomeManagerFactoryClass() throws ClassNotFoundException {
        return this.properties.getClass(HOME_MANAGER_FACTORY_IMPLEMENTATION);
    }

    public String getPersistenceFolder() throws InternalErrorException {
        this.logger.info((Object)"calculating the persistence folder");
        String persistenceFolder = null;
        if (this.properties.containsKey(PERSISTENCE_FOLDER)) {
            this.logger.debug((Object)"Persistence Folder specified through the properties file");
            persistenceFolder = this.properties.getString(PERSISTENCE_FOLDER);
        } else {
            String baseDir;
            this.logger.trace((Object)"calculating the base dir");
            if (System.getenv().containsKey(HOME_LIBRARY_PERSISTENCE_DIR_VARIABLE_NAME)) {
                this.logger.debug((Object)"Base dir specified through the environment dir variable");
                String envVariable = System.getenv(HOME_LIBRARY_PERSISTENCE_DIR_VARIABLE_NAME);
                this.logger.debug((Object)("HOME_LIBRARY_PERSISTENCE_DIR = " + envVariable));
                baseDir = envVariable;
            } else if (System.getProperties().containsKey("catalina.base")) {
                String catalinaBase = System.getProperty("catalina.base");
                this.logger.info((Object)("Using catalina.base property " + catalinaBase));
                baseDir = catalinaBase + File.separator + "webapps" + File.separator + "usersArea";
            } else {
                String tmpDir = System.getProperty("java.io.tmpdir");
                this.logger.info((Object)("Using tmp dir " + tmpDir));
                baseDir = tmpDir;
            }
            persistenceFolder = baseDir + File.separator + "home_library_persistence";
        }
        this.logger.trace((Object)("calculated persistenceFolder = " + persistenceFolder));
        return persistenceFolder;
    }
}

