/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryRemoval;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;

public class JCRAccountingFolderEntryRemoval
extends JCRAccountingEntry
implements AccountingEntryRemoval {
    private static String ITEM_TYPE = "hl:itemType";
    private static String FOLDER_ITEM_TYPE = "hl:folderItemType";
    private static String ITEM_NAME = "hl:itemName";
    private static String MIME_TYPE = "hl:mimeType";
    protected WorkspaceItemType itemType;
    protected FolderItemType folderItemType;
    protected String itemName;
    protected String mimeType;

    public JCRAccountingFolderEntryRemoval(Node node) throws RepositoryException {
        super(node);
        this.itemName = node.getProperty(ITEM_NAME).getString();
        this.itemType = WorkspaceItemType.valueOf((String)node.getProperty(ITEM_TYPE).getString());
        this.folderItemType = node.hasProperty(FOLDER_ITEM_TYPE) ? FolderItemType.valueOf((String)node.getProperty(FOLDER_ITEM_TYPE).getString()) : null;
        this.mimeType = node.hasProperty(MIME_TYPE) ? node.getProperty(MIME_TYPE).getString() : null;
    }

    public JCRAccountingFolderEntryRemoval(String user, Calendar date, WorkspaceItemType itemType, FolderItemType folderItemType, String itemName, String mimeType) {
        super(user, date);
        this.itemName = itemName;
        this.folderItemType = folderItemType;
        this.itemType = itemType;
        this.mimeType = mimeType;
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.REMOVAL;
    }

    public WorkspaceItemType getItemType() {
        return this.itemType;
    }

    public FolderItemType getFolderItemType() {
        return this.folderItemType;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public void save(Node entryNode) throws RepositoryException {
        super.save(entryNode);
        entryNode.setProperty(ITEM_NAME, this.itemName);
        entryNode.setProperty(ITEM_TYPE, this.itemType.toString());
        if (this.folderItemType != null) {
            entryNode.setProperty(FOLDER_ITEM_TYPE, this.folderItemType.toString());
        }
        if (this.mimeType != null) {
            entryNode.setProperty(MIME_TYPE, this.mimeType);
        }
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s, itemName:%s, itemType:%s, folderItemType:%s, mimeType:%s]]", parentValue, AccountingEntryType.REMOVAL, this.itemName, this.itemType, this.folderItemType, this.mimeType);
    }
}

