package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube;

import java.io.InputStream;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRImage;

public class JCRImageDocument extends JCRDocument implements ImageDocument {

	public static final String REMOTE_STORAGE_PATH 	=  	"hl:remotePath";
	protected String nodeId;

	public JCRImageDocument(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
		super(workspace, node, ContentType.IMAGE);	
		this.nodeId = node.getIdentifier();
	}

	public JCRImageDocument(JCRWorkspace workspace, Node node, String name,
			String description, String oid, String mimeType,
			InputStream documentData, Map<String, String> metadata,
			Map<String, String> annotations, String collectionName) 
					throws RepositoryException, InternalErrorException {
		super(workspace, node, name, description, oid, mimeType, ContentType.IMAGE, documentData,
				metadata, annotations, collectionName);	

		try {
			node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.IMAGE_DOCUMENT.toString());
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		}
	}

	@Override
	public int getWidth() {
		return ((JCRImage)documentContent).getWidth();
	}

	@Override
	public int getHeight() {
		return ((JCRImage)documentContent).getWidth();
	}

	@Override
	public InputStream getThumbnail() throws InternalErrorException {
		return ((JCRImage)documentContent).getThumbnail();
	}

	@Override
	public int getThumbnailWidth() {
		return ((JCRImage)documentContent).getThumbnailWidth();
	}

	@Override
	public int getThumbnailHeight() {
		return ((JCRImage)documentContent).getThumbnailHeight();
	}

	@Override
	public long getThumbnailLength() throws InternalErrorException {
		return ((JCRImage)documentContent).getThumbnailLength();
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.IMAGE_DOCUMENT;
	}

	@Override
	public String getPublicLink() throws InternalErrorException {
		String remotePath = null;
		Session session = JCRRepository.getSession();
		try {
			Node node = session.getNodeByIdentifier(nodeId);
			try {
				remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
			} catch (PathNotFoundException e) {
				logger.trace("Old retrieve content method");
			}
			return GCUBEStorage.getPublicLink(remotePath);
		} catch (Exception e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

	}

	@Override
	public void getHardLink(String linkName) throws InternalErrorException {

		String remotePath = null;
		Session session = JCRRepository.getSession();
		try {
			Node node = session.getNodeByIdentifier(nodeId);
			try {
				remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
			} catch (PathNotFoundException e) {
				logger.trace("Old retrieve content method");
			}
			GCUBEStorage.createHardLink(remotePath, linkName);
		} catch (Exception e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}	
	}

	@Override
	public void updateInfo() throws InternalErrorException {
		((JCRImage)documentContent).updateInfo();

	}


}
