/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryCut;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;

/**
 * @author Antonio Gioia antonio.gioia@isti.cnr.it
 *
 */
public class JCRAccountingFolderEntryCut extends
		JCRAccountingFolderEntryRemoval implements AccountingEntryCut {

	/**
	 * @param user
	 * @param date
	 * @param itemType
	 * @param folderItemType
	 * @param itemName
	 * @param mimeType
	 */
	public JCRAccountingFolderEntryCut(String user, Calendar date,
			WorkspaceItemType itemType, FolderItemType folderItemType,
			String itemName, String mimeType) {
		super(user, date, itemType, folderItemType, itemName, mimeType);
	}
	
	
	public JCRAccountingFolderEntryCut(Node node) throws RepositoryException {
		super(node);
	}

	@Override
	public AccountingEntryType getEntryType() {
		return AccountingEntryType.CUT;
	}
	
	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s, itemName:%s, itemType:%s, folderItemType:%s, mimeType:%s]]",
				parentValue, AccountingEntryType.CUT, itemName, itemType, folderItemType, mimeType);
	}
	

}
