/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;

/**
 * @author Antonio Gioia antonio.gioia@isti.cnr.it
 *
 */
public class JCRAccountingEntryRead extends JCRAccountingEntry  implements AccountingEntryRead {

	
	private static String ITEM_NAME 			= "hl:itemName";
	
	protected String itemName;

	/**
	 * @param node
	 * @throws RepositoryException
	 */
	public JCRAccountingEntryRead(Node node) throws RepositoryException {
		
		super(node);
		this.itemName =  node.getProperty(ITEM_NAME).getString();

	}
	
	public JCRAccountingEntryRead(String user, Calendar date, String nodeName) {
		super(user,date);
		
		this.itemName = nodeName;
	}

	
	@Override
	public void save(Node entryNode) throws RepositoryException {
		super.save(entryNode);
		
		entryNode.setProperty(ITEM_NAME, itemName);
	}
	
	@Override
	public String getItemName() {		
		return itemName;
	}
	
	@Override
	public AccountingEntryType getEntryType() {
		return AccountingEntryType.READ;
	}

	@Override
	public String toString() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String user = super.getUser();
		Calendar date = super.getDate();
		return String.format("Read[ itemName:%s, user:%s, date:%s ]", itemName, user,sdf.format(date.getTime()));
	}


}
