package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;

public class JCRExternalPDFFile extends JCRExternalFile implements
		ExternalPDFFile {

	public JCRExternalPDFFile(JCRWorkspace workspace, Node node) throws RepositoryException {
		super(workspace, node, ContentType.PDF);
		
		
	}
	
	public JCRExternalPDFFile(JCRWorkspace workspace, Node node, String name,
			String description, String mimeType, InputStream fileData) throws RepositoryException, IOException, RemoteBackendException {
		super(workspace,node,name,description,mimeType,ContentType.PDF,fileData);
		
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.EXTERNAL_PDF_FILE;	
	}

	@Override
	public int getNumberOfPages() {	
		return ((JCRPDFFile)content).getNumberOfPages();
	}

	@Override
	public String getVersion() {
		return ((JCRPDFFile)content).getVersion();
	}

	@Override
	public String getAuthor() {
		return ((JCRPDFFile)content).getAuthor();
	}

	@Override
	public String getTitle() {
		return ((JCRPDFFile)content).getTitle();
	}

	@Override
	public String getProducer() {
		return ((JCRPDFFile)content).getProducer();
	}

	@Override
	public void updateInfo() throws InternalErrorException {
//		System.out.println("updateInfo in JCRExternalPDFFile");
		super.updateInfo();
	}

	
}
