/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.search;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.portlets.user.homelibrary.jcr.workspace.search.JCRSearchFolder;

public class JCRSearchFolderItem
extends JCRSearchFolder
implements SearchFolderItem {
    protected static final String CONTENT = "jcr:content";
    protected static final String DATA = "jcr:data";
    private static final String MIME_TYPE = "jcr:mimeType";
    private static final String SIZE = "hl:size";
    private long size;
    private String mimeType;
    private final FolderItemType folderItemType;

    public JCRSearchFolderItem(Node node, FolderItemType type, String name) throws RepositoryException {
        super(node, name);
        this.folderItemType = type;
        try {
            Node contentNode = node.getNode(CONTENT);
            this.mimeType = contentNode.getProperty(MIME_TYPE).getString();
            this.size = contentNode.getProperty(SIZE).getLong();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    public long getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.FOLDER_ITEM;
    }

    public FolderItemType getFolderItemType() {
        return this.folderItemType;
    }
}

