/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.Validate;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRPDFFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRExternalFile
extends JCRWorkspaceFolderItem
implements ExternalFile {
    protected JCRFile content;
    protected String nodeId;

    public JCRExternalFile(JCRWorkspace workspace, Node node) throws RepositoryException {
        this(workspace, node, ContentType.GENERAL);
        this.nodeId = node.getIdentifier();
    }

    public JCRExternalFile(JCRWorkspace workspace, Node node, String name, String description, String mimeType, InputStream data) throws RepositoryException, IOException, RemoteBackendException {
        this(workspace, node, name, description, mimeType, ContentType.GENERAL, data);
    }

    protected JCRExternalFile(JCRWorkspace workspace, Node node, ContentType contentType) throws RepositoryException {
        super(workspace, node);
        switch (contentType) {
            case GENERAL: {
                Node file = node.getNode("jcr:content");
                this.content = new JCRFile(file);
                break;
            }
            case IMAGE: {
                Node image = node.getNode("jcr:content");
                this.content = new JCRImage(image);
                break;
            }
            case PDF: {
                Node pdf = node.getNode("jcr:content");
                this.content = new JCRPDFFile(pdf);
                break;
            }
            default: {
                this.content = null;
            }
        }
    }

    protected JCRExternalFile(JCRWorkspace workspace, Node node, String name, String description, String mimeType, ContentType contentType, InputStream data) throws RepositoryException, IOException, RemoteBackendException {
        super(workspace, node, name, description);
        Validate.notNull((Object)data, (String)"Data must be not null");
        switch (contentType) {
            case GENERAL: {
                Node contentNode = node.addNode("jcr:content", ContentType.GENERAL.toString());
                node.setProperty("hl:workspaceItemType", FolderItemType.EXTERNAL_FILE.toString());
                this.content = new JCRFile(contentNode, mimeType != null ? mimeType : "application/octet-stream", data);
                break;
            }
            case IMAGE: {
                Node contentNode = node.addNode("jcr:content", ContentType.IMAGE.toString());
                node.setProperty("hl:workspaceItemType", FolderItemType.EXTERNAL_IMAGE.toString());
                this.content = new JCRImage(contentNode, data);
                break;
            }
            case PDF: {
                Node contentNode = node.addNode("jcr:content", ContentType.PDF.toString());
                node.setProperty("hl:workspaceItemType", FolderItemType.EXTERNAL_PDF_FILE.toString());
                this.content = new JCRPDFFile(contentNode, mimeType, data);
                break;
            }
            default: {
                this.content = null;
            }
        }
    }

    @Override
    public String getMimeType() {
        return this.content.getMimeType();
    }

    public InputStream getData() throws InternalErrorException {
        return this.content.getData();
    }

    @Override
    public long getLength() throws InternalErrorException {
        return this.content.getLength();
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.EXTERNAL_FILE;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
        this.content.save(node);
    }

    public void setData(InputStream data) throws InternalErrorException {
        Validate.notNull((Object)data, (String)"Data must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            FolderItemType type = FolderItemType.valueOf((String)node.getProperty("hl:workspaceItemType").getString());
            switch (type) {
                case EXTERNAL_FILE: {
                    this.content = new JCRFile(node.getNode("jcr:content"), this.content.getMimeType(), data);
                    break;
                }
                case EXTERNAL_IMAGE: {
                    this.content = new JCRImage(node.getNode("jcr:content"), data);
                    break;
                }
                case EXTERNAL_PDF_FILE: {
                    this.content = new JCRPDFFile(node.getNode("jcr:content"), this.content.getMimeType(), data);
                    break;
                }
                default: {
                    throw new InternalErrorException("Item type wrong" + type);
                }
            }
            session.save();
            this.content.save(node.getNode("jcr:content"));
        }
        catch (Exception e) {
            throw new InternalErrorException("Content appears to be not valid: " + e.getMessage());
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String getPublicLink() throws InternalErrorException {
        return this.content.getPublicLink();
    }

    public void getHardLink(String linkName) throws InternalErrorException {
        this.content.getHardLink(linkName);
    }

    public void updateInfo() throws InternalErrorException {
        this.content.updateInfo();
    }
}

