/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.TabularDataLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRTabularDataLink
extends JCRWorkspaceFolderItem
implements TabularDataLink {
    private static final String NT_CONTENT = "nthl:tabularDataLinkContent";
    private static final String TABLE_ID = "hl:tableID";
    private static final String TABLE_TEMPLATE = "hl:tableTemplateID";
    private static final String PROVENANCE = "hl:provenance";
    private static final String RUNTIME_RESOURCE = "hl:runtimeResourceID";
    private static final String OPERATOR = "hl:operator";
    private final String tableId;
    private final String template;
    private final TabularDataLink.Provenance provenance;
    private final String runtimeResource;
    private String operator;

    public JCRTabularDataLink(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
        Node contentNode = node.getNode("jcr:content");
        this.tableId = contentNode.getProperty(TABLE_ID).getString();
        this.template = contentNode.getProperty(TABLE_TEMPLATE).getString();
        this.provenance = TabularDataLink.Provenance.valueOf((String)contentNode.getProperty(PROVENANCE).getString());
        this.runtimeResource = contentNode.getProperty(RUNTIME_RESOURCE).getString();
        if (contentNode.hasProperty(OPERATOR)) {
            this.operator = contentNode.getProperty(OPERATOR).getString();
        }
    }

    public JCRTabularDataLink(JCRWorkspace workspace, Node node, String name, String description, String tableId, String template, TabularDataLink.Provenance provenance, String operator, String runtimeResource) throws RepositoryException {
        super(workspace, node, name, description);
        this.tableId = tableId;
        this.template = template;
        this.provenance = provenance;
        this.runtimeResource = runtimeResource;
        this.operator = operator;
        Node contentNode = node.addNode("jcr:content", NT_CONTENT);
        contentNode.setProperty(TABLE_ID, tableId);
        contentNode.setProperty(TABLE_TEMPLATE, template);
        contentNode.setProperty(PROVENANCE, provenance.toString());
        contentNode.setProperty(RUNTIME_RESOURCE, runtimeResource);
        if (operator != null) {
            contentNode.setProperty(OPERATOR, operator);
        }
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getTemplate() {
        return this.template;
    }

    public TabularDataLink.Provenance getProvenance() {
        return this.provenance;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.TABULAR_DATA_LINK;
    }

    @Override
    public long getLength() throws InternalErrorException {
        return 0L;
    }

    public String getDBRuntimeResource() {
        return this.runtimeResource;
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }

    public String getOperator() {
        return this.operator;
    }
}

