/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryCreate;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryUpdate;

/**
 * @author Valentina Marioli valentina.marioli@isti.cnr.it
 *
 */
public class JCRAccountingEntryUpdate extends JCRAccountingEntry implements AccountingEntryUpdate {
	
	protected String itemName;

	/**
	 * @param node
	 * @throws RepositoryException
	 */
	public JCRAccountingEntryUpdate(Node node) throws RepositoryException {
		
		super(node);
		this.itemName = node.getName();
		// TODO Auto-generated constructor stub
	}
	
	public JCRAccountingEntryUpdate(String user, Calendar date) {
		super(user,date);
	}

	@Override
	public AccountingEntryType getEntryType() {
		return AccountingEntryType.UPDATE;
	}
	
	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s]]",parentValue, getEntryType());
	}
	
	@Override
	public String getItemName() {		
		return itemName;
	}

}
