/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;



/**
 * @author gioia
 *
 */
public enum JCRAccountingEntryType {
	
	CREATE("nthl:accountingEntryCreate"),
	
	REMOVAL("nthl:accountingFolderEntryRemoval"),
	
	RENAMING("nthl:accountingFolderEntryRenaming"),
	
	PASTE("nthl:accountingEntryPaste"),
	
	CUT("nthl:accountingFolderEntryCut"),
	
	READ("nthl:accountingEntryRead");
	
	private String nodeTypeDefinition;
	
	JCRAccountingEntryType(String value) {
		this.nodeTypeDefinition = value;
	}
	
	public String getNodeTypeDefinition() {
		return nodeTypeDefinition;
	}
	
	public static JCRAccountingEntryType getEnum(String value) {
		for (JCRAccountingEntryType entry : JCRAccountingEntryType.values()) {
			if (entry.getNodeTypeDefinition().compareTo(value) == 0) {
				return entry;
			}
		}
		return null;
	}
}
