/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Properties;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemAccounting;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.TabularDataLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;


/**
 * @author gioia
 *
 */
public class JCRTabularDataLink extends JCRWorkspaceFolderItem implements TabularDataLink {
	
	private static final String NT_CONTENT 		= "nthl:externalResourceLinkContent";
	
	private static final String TABLE_ID = "";
	private static final String TABLE_TEMPLATE = "";
	private static final String PROVENANCE = "";
	private static final String RUNTIME_RESOURCE = "";

	private String tableId;
	private String template;
	private String provenance;
	private String runtimeResource;
	
	public JCRTabularDataLink(JCRWorkspace workspace, Node node)
			throws RepositoryException {
		super(workspace, node);
		
		Node contentNode = node.getNode(CONTENT);
		this.tableId = contentNode.getProperty(TABLE_ID).getString();
		this.template = contentNode.getProperty(TABLE_TEMPLATE).getString();
		this.provenance = contentNode.getProperty(PROVENANCE).getString();
		this.runtimeResource = contentNode.getProperty(RUNTIME_RESOURCE).getString();
		
	}
	
	public JCRTabularDataLink(JCRWorkspace workspace, Node node, String name, String description,
			 String tableId, String template, String provenance, String runtimeResource) throws RepositoryException {
		super(workspace, node, name, description);

		
		Node contentNode = node.addNode(CONTENT, NT_CONTENT); 
		
		contentNode.setProperty(TABLE_ID, tableId);
		contentNode.setProperty(TABLE_TEMPLATE, template);
		contentNode.setProperty(PROVENANCE, provenance);
		contentNode.setProperty(RUNTIME_RESOURCE, runtimeResource);
		
	}

	@Override
	public String getTableId() {
		return tableId;
	}


	@Override
	public String getTemplate() {
		return template;
	}

	@Override
	public String getProvenance() {
		return provenance;
	}

	
	@Override
	public void saveContent(Node node) throws RepositoryException {
		return;
	}

	@Override
	public FolderItemType getFolderItemType() {
		
		return FolderItemType.TABULAR_DATA_LINK;
	}

	@Override
	public long getLength() throws InternalErrorException {
		return 0;
	}

	@Override
	public String getDBRuntimeResource() {
		return runtimeResource;
	}
	
}
