package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.util.MimeTypeUtil;

import com.liferay.portal.kernel.util.MimeTypesUtil;


public class JCRExternalFile extends JCRWorkspaceFolderItem implements ExternalFile {
	
	protected final JCRFile content;
	
	public JCRExternalFile(JCRWorkspace workspace, Node node) throws RepositoryException {
		this(workspace,node,ContentType.GENERAL);
	}
	
	public JCRExternalFile(JCRWorkspace workspace, Node node, String name, String description,
			String mimeType, InputStream data) throws RepositoryException, IOException   {
		this(workspace,node,name,description,mimeType,ContentType.GENERAL,data);
		
		
	}
	
	protected JCRExternalFile(JCRWorkspace workspace, Node node, ContentType contentType) throws RepositoryException {
		super(workspace, node);
		
		switch(contentType) {
		case GENERAL:
			Node file = node.getNode(CONTENT);
			this.content = new JCRFile(file);
			break;
		case IMAGE:
			Node image = node.getNode(CONTENT);
			this.content = new JCRImage(image);
			break;
		case PDF:
			Node pdf = node.getNode(CONTENT);
			this.content = new JCRPDFFile(pdf);
			break;
		default:
			this.content = null;
		}

	}
	
	protected JCRExternalFile(JCRWorkspace workspace, Node node, String name, String description,
			String mimeType, ContentType contentType, InputStream data) throws RepositoryException, IOException {
		super(workspace, node, name, description);
		
		Validate.notNull(data, "Data must be not null");
				
		switch(contentType) {
		case GENERAL: {
			Node contentNode = node.addNode(CONTENT,ContentType.GENERAL.toString());
			node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_FILE.toString());
			if (mimeType == null)
				mimeType = MimeTypeUtil.getMimeType(new BufferedInputStream(data));
			this.content = new JCRFile(contentNode,mimeType,data);
			break;
		}
		case IMAGE: {
			Node contentNode = node.addNode(CONTENT,ContentType.IMAGE.toString());
			node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_IMAGE.toString());
			this.content = new JCRImage(contentNode,data);
			break;
		}
		case PDF: {
			Node contentNode = node.addNode(CONTENT,ContentType.PDF.toString());
			node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_PDF_FILE.toString());
			this.content = new JCRPDFFile(contentNode, mimeType, data);
			break;
		}
		default:
			this.content = null;
		}

	}

	@Override
	public String getMimeType() {
		return content.getMimeType();
	}

	@Override
	public InputStream getData() throws InternalErrorException {
		return content.getData();
	}

	@Override
	public long getLength() throws InternalErrorException {
		return content.getLength();
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.EXTERNAL_FILE;
	}


	@Override
	public void saveContent(Node node) throws RepositoryException {
		content.save(node);
	}

}
