/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRPDFFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.portlets.user.homelibrary.util.MimeTypeUtil;

public class JCRExternalFile
extends JCRWorkspaceFolderItem
implements ExternalFile {
    protected final JCRFile content;

    public JCRExternalFile(JCRWorkspace workspace, Node node) throws RepositoryException {
        this(workspace, node, ContentType.GENERAL);
    }

    public JCRExternalFile(JCRWorkspace workspace, Node node, String name, String description, String mimeType, InputStream data) throws RepositoryException, IOException {
        this(workspace, node, name, description, mimeType, ContentType.GENERAL, data);
    }

    protected JCRExternalFile(JCRWorkspace workspace, Node node, ContentType contentType) throws RepositoryException {
        super(workspace, node);
        switch (contentType) {
            case GENERAL: {
                Node file = node.getNode("jcr:content");
                this.content = new JCRFile(file);
                break;
            }
            case IMAGE: {
                Node image = node.getNode("jcr:content");
                this.content = new JCRImage(image);
                break;
            }
            case PDF: {
                Node pdf = node.getNode("jcr:content");
                this.content = new JCRPDFFile(pdf);
                break;
            }
            default: {
                this.content = null;
            }
        }
    }

    protected JCRExternalFile(JCRWorkspace workspace, Node node, String name, String description, String mimeType, ContentType contentType, InputStream data) throws RepositoryException, IOException {
        super(workspace, node, name, description);
        Validate.notNull((Object)data, (String)"Data must be not null");
        switch (contentType) {
            case GENERAL: {
                Node contentNode = node.addNode("jcr:content", ContentType.GENERAL.toString());
                node.setProperty("hl:workspaceItemType", FolderItemType.EXTERNAL_FILE.toString());
                if (mimeType == null) {
                    mimeType = MimeTypeUtil.getMimeType((InputStream)new BufferedInputStream(data));
                }
                this.content = new JCRFile(contentNode, mimeType, data);
                break;
            }
            case IMAGE: {
                Node contentNode = node.addNode("jcr:content", ContentType.IMAGE.toString());
                node.setProperty("hl:workspaceItemType", FolderItemType.EXTERNAL_IMAGE.toString());
                this.content = new JCRImage(contentNode, data);
                break;
            }
            case PDF: {
                Node contentNode = node.addNode("jcr:content", ContentType.PDF.toString());
                node.setProperty("hl:workspaceItemType", FolderItemType.EXTERNAL_PDF_FILE.toString());
                this.content = new JCRPDFFile(contentNode, mimeType, data);
                break;
            }
            default: {
                this.content = null;
            }
        }
    }

    public String getMimeType() {
        return this.content.getMimeType();
    }

    public InputStream getData() throws InternalErrorException {
        return this.content.getData();
    }

    @Override
    public long getLength() throws InternalErrorException {
        return this.content.getLength();
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.EXTERNAL_FILE;
    }

    @Override
    public void saveContent(Node node) throws RepositoryException {
        this.content.save(node);
    }
}

