/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Properties;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;

public class JCRProperties
implements Properties {
    private static final String PROPERTIES = "hl:metadata";
    private String identifier;

    public JCRProperties(Node itemNode) throws RepositoryException {
        this.identifier = itemNode.getIdentifier();
    }

    public String getId() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = node.getNode(PROPERTIES).getIdentifier();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getPropertyValue(String propertyName) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node itemNode = session.getNodeByIdentifier(this.identifier);
            String string = itemNode.getNode(PROPERTIES).getProperty(propertyName).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Map<String, String> getProperties() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node itemNode = session.getNodeByIdentifier(this.identifier);
            HashMap<String, String> map = new HashMap<String, String>();
            PropertyIterator iterator = itemNode.getNode(PROPERTIES).getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                if (property.getName().startsWith("jcr:")) continue;
                String unescapeName = Text.unescape((String)property.getName());
                map.put(unescapeName, property.getValue().toString());
            }
            Map<String, String> map2 = Collections.unmodifiableMap(map);
            return map2;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void addProperty(String name, String value) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node itemNode = session.getNodeByIdentifier(this.identifier);
            String escapeName = Text.escapeIllegalJcrChars((String)name);
            itemNode.getNode(PROPERTIES).setProperty(escapeName, value);
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }
}

